/*
 Highstock JS v8.0.0 (2019-12-10)

 Highstock as a plugin for Highcharts

 (c) 2010-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(n){"object"===typeof module&&module.exports?(n["default"]=n,module.exports=n):"function"===typeof define&&define.amd?define("highcharts/modules/stock",["highcharts"],function(H){n(H);n.Highcharts=H;return n}):n("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(n){function H(e,h,n,C){e.hasOwnProperty(h)||(e[h]=C.apply(null,n))}n=n?n._modules:{};H(n,"parts/Scrollbar.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,h){function n(a,c,m){this.init(a,c,m)}var C=h.correctFloat,
B=h.defined,D=h.destroyObjectProperties,E=h.pick,t=e.addEvent;h=e.Axis;var x=e.defaultOptions,w=e.fireEvent,f=e.hasTouch,v=e.merge,p=e.removeEvent,q,k={height:e.isTouchDevice?20:14,barBorderRadius:0,buttonBorderRadius:0,liveRedraw:void 0,margin:10,minWidth:6,step:.2,zIndex:3,barBackgroundColor:"#cccccc",barBorderWidth:1,barBorderColor:"#cccccc",buttonArrowColor:"#333333",buttonBackgroundColor:"#e6e6e6",buttonBorderColor:"#cccccc",buttonBorderWidth:1,rifleColor:"#333333",trackBackgroundColor:"#f2f2f2",
trackBorderColor:"#f2f2f2",trackBorderWidth:1};x.scrollbar=v(!0,k,x.scrollbar);e.swapXY=q=function(a,c){var m=a.length;if(c)for(c=0;c<m;c+=3){var f=a[c+1];a[c+1]=a[c+2];a[c+2]=f}return a};n.prototype={init:function(a,c,m){this.scrollbarButtons=[];this.renderer=a;this.userOptions=c;this.options=v(k,c);this.chart=m;this.size=E(this.options.size,this.options.height);c.enabled&&(this.render(),this.initEvents(),this.addEvents())},render:function(){var a=this.renderer,c=this.options,m=this.size,f=this.chart.styledMode,
d;this.group=d=a.g("scrollbar").attr({zIndex:c.zIndex,translateY:-99999}).add();this.track=a.rect().addClass("highcharts-scrollbar-track").attr({x:0,r:c.trackBorderRadius||0,height:m,width:m}).add(d);f||this.track.attr({fill:c.trackBackgroundColor,stroke:c.trackBorderColor,"stroke-width":c.trackBorderWidth});this.trackBorderWidth=this.track.strokeWidth();this.track.attr({y:-this.trackBorderWidth%2/2});this.scrollbarGroup=a.g().add(d);this.scrollbar=a.rect().addClass("highcharts-scrollbar-thumb").attr({height:m,
width:m,r:c.barBorderRadius||0}).add(this.scrollbarGroup);this.scrollbarRifles=a.path(q(["M",-3,m/4,"L",-3,2*m/3,"M",0,m/4,"L",0,2*m/3,"M",3,m/4,"L",3,2*m/3],c.vertical)).addClass("highcharts-scrollbar-rifles").add(this.scrollbarGroup);f||(this.scrollbar.attr({fill:c.barBackgroundColor,stroke:c.barBorderColor,"stroke-width":c.barBorderWidth}),this.scrollbarRifles.attr({stroke:c.rifleColor,"stroke-width":1}));this.scrollbarStrokeWidth=this.scrollbar.strokeWidth();this.scrollbarGroup.translate(-this.scrollbarStrokeWidth%
2/2,-this.scrollbarStrokeWidth%2/2);this.drawScrollbarButton(0);this.drawScrollbarButton(1)},position:function(a,c,m,f){var d=this.options.vertical,l=0,r=this.rendered?"animate":"attr";this.x=a;this.y=c+this.trackBorderWidth;this.width=m;this.xOffset=this.height=f;this.yOffset=l;d?(this.width=this.yOffset=m=l=this.size,this.xOffset=c=0,this.barWidth=f-2*m,this.x=a+=this.options.margin):(this.height=this.xOffset=f=c=this.size,this.barWidth=m-2*f,this.y+=this.options.margin);this.group[r]({translateX:a,
translateY:this.y});this.track[r]({width:m,height:f});this.scrollbarButtons[1][r]({translateX:d?0:m-c,translateY:d?f-l:0})},drawScrollbarButton:function(a){var c=this.renderer,m=this.scrollbarButtons,f=this.options,d=this.size;var l=c.g().add(this.group);m.push(l);l=c.rect().addClass("highcharts-scrollbar-button").add(l);this.chart.styledMode||l.attr({stroke:f.buttonBorderColor,"stroke-width":f.buttonBorderWidth,fill:f.buttonBackgroundColor});l.attr(l.crisp({x:-.5,y:-.5,width:d+1,height:d+1,r:f.buttonBorderRadius},
l.strokeWidth()));l=c.path(q(["M",d/2+(a?-1:1),d/2-3,"L",d/2+(a?-1:1),d/2+3,"L",d/2+(a?2:-2),d/2],f.vertical)).addClass("highcharts-scrollbar-arrow").add(m[a]);this.chart.styledMode||l.attr({fill:f.buttonArrowColor})},setRange:function(a,c){var m=this.options,f=m.vertical,d=m.minWidth,l=this.barWidth,r,k=!this.rendered||this.hasDragged||this.chart.navigator&&this.chart.navigator.hasDragged?"attr":"animate";if(B(l)){a=Math.max(a,0);var v=Math.ceil(l*a);this.calculatedWidth=r=C(l*Math.min(c,1)-v);r<
d&&(v=(l-d+r)*a,r=d);d=Math.floor(v+this.xOffset+this.yOffset);l=r/2-.5;this.from=a;this.to=c;f?(this.scrollbarGroup[k]({translateY:d}),this.scrollbar[k]({height:r}),this.scrollbarRifles[k]({translateY:l}),this.scrollbarTop=d,this.scrollbarLeft=0):(this.scrollbarGroup[k]({translateX:d}),this.scrollbar[k]({width:r}),this.scrollbarRifles[k]({translateX:l}),this.scrollbarLeft=d,this.scrollbarTop=0);12>=r?this.scrollbarRifles.hide():this.scrollbarRifles.show(!0);!1===m.showFull&&(0>=a&&1<=c?this.group.hide():
this.group.show());this.rendered=!0}},initEvents:function(){var a=this;a.mouseMoveHandler=function(c){var m=a.chart.pointer.normalize(c),f=a.options.vertical?"chartY":"chartX",d=a.initPositions;!a.grabbedCenter||c.touches&&0===c.touches[0][f]||(m=a.cursorToScrollbarPosition(m)[f],f=a[f],f=m-f,a.hasDragged=!0,a.updatePosition(d[0]+f,d[1]+f),a.hasDragged&&w(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMType:c.type,DOMEvent:c}))};a.mouseUpHandler=function(c){a.hasDragged&&w(a,"changed",{from:a.from,
to:a.to,trigger:"scrollbar",DOMType:c.type,DOMEvent:c});a.grabbedCenter=a.hasDragged=a.chartX=a.chartY=null};a.mouseDownHandler=function(c){c=a.chart.pointer.normalize(c);c=a.cursorToScrollbarPosition(c);a.chartX=c.chartX;a.chartY=c.chartY;a.initPositions=[a.from,a.to];a.grabbedCenter=!0};a.buttonToMinClick=function(c){var f=C(a.to-a.from)*a.options.step;a.updatePosition(C(a.from-f),C(a.to-f));w(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:c})};a.buttonToMaxClick=function(c){var f=
(a.to-a.from)*a.options.step;a.updatePosition(a.from+f,a.to+f);w(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:c})};a.trackClick=function(c){var f=a.chart.pointer.normalize(c),k=a.to-a.from,d=a.y+a.scrollbarTop,l=a.x+a.scrollbarLeft;a.options.vertical&&f.chartY>d||!a.options.vertical&&f.chartX>l?a.updatePosition(a.from+k,a.to+k):a.updatePosition(a.from-k,a.to-k);w(a,"changed",{from:a.from,to:a.to,trigger:"scrollbar",DOMEvent:c})}},cursorToScrollbarPosition:function(a){var c=this.options;
c=c.minWidth>this.calculatedWidth?c.minWidth:0;return{chartX:(a.chartX-this.x-this.xOffset)/(this.barWidth-c),chartY:(a.chartY-this.y-this.yOffset)/(this.barWidth-c)}},updatePosition:function(a,c){1<c&&(a=C(1-C(c-a)),c=1);0>a&&(c=C(c-a),a=0);this.from=a;this.to=c},update:function(a){this.destroy();this.init(this.chart.renderer,v(!0,this.options,a),this.chart)},addEvents:function(){var a=this.options.inverted?[1,0]:[0,1],c=this.scrollbarButtons,m=this.scrollbarGroup.element,k=this.mouseDownHandler,
d=this.mouseMoveHandler,l=this.mouseUpHandler;a=[[c[a[0]].element,"click",this.buttonToMinClick],[c[a[1]].element,"click",this.buttonToMaxClick],[this.track.element,"click",this.trackClick],[m,"mousedown",k],[m.ownerDocument,"mousemove",d],[m.ownerDocument,"mouseup",l]];f&&a.push([m,"touchstart",k],[m.ownerDocument,"touchmove",d],[m.ownerDocument,"touchend",l]);a.forEach(function(d){t.apply(null,d)});this._events=a},removeEvents:function(){this._events.forEach(function(a){p.apply(null,a)});this._events.length=
0},destroy:function(){var a=this.chart.scroller;this.removeEvents();["track","scrollbarRifles","scrollbar","scrollbarGroup","group"].forEach(function(a){this[a]&&this[a].destroy&&(this[a]=this[a].destroy())},this);a&&this===a.scrollbar&&(a.scrollbar=null,D(a.scrollbarButtons))}};e.Scrollbar||(t(h,"afterInit",function(){var a=this;a.options&&a.options.scrollbar&&a.options.scrollbar.enabled&&(a.options.scrollbar.vertical=!a.horiz,a.options.startOnTick=a.options.endOnTick=!1,a.scrollbar=new n(a.chart.renderer,
a.options.scrollbar,a.chart),t(a.scrollbar,"changed",function(c){var f=Math.min(E(a.options.min,a.min),a.min,a.dataMin),k=Math.max(E(a.options.max,a.max),a.max,a.dataMax)-f;if(a.horiz&&!a.reversed||!a.horiz&&a.reversed){var d=f+k*this.to;f+=k*this.from}else d=f+k*(1-this.from),f+=k*(1-this.to);E(this.options.liveRedraw,e.svg&&!e.isTouchDevice&&!this.chart.isBoosting)||"mouseup"===c.DOMType||!B(c.DOMType)?a.setExtremes(f,d,!0,"mousemove"!==c.DOMType,c):this.setRange(this.from,this.to)}))}),t(h,"afterRender",
function(){var a=Math.min(E(this.options.min,this.min),this.min,E(this.dataMin,this.min)),c=Math.max(E(this.options.max,this.max),this.max,E(this.dataMax,this.max)),f=this.scrollbar,k=this.axisTitleMargin+(this.titleOffset||0),d=this.chart.scrollbarsOffsets,l=this.options.margin||0;f&&(this.horiz?(this.opposite||(d[1]+=k),f.position(this.left,this.top+this.height+2+d[1]-(this.opposite?l:0),this.width,this.height),this.opposite||(d[1]+=l),k=1):(this.opposite&&(d[0]+=k),f.position(this.left+this.width+
2+d[0]-(this.opposite?0:l),this.top,this.width,this.height),this.opposite&&(d[0]+=l),k=0),d[k]+=f.size+f.options.margin,isNaN(a)||isNaN(c)||!B(this.min)||!B(this.max)||this.min===this.max?f.setRange(0,1):(d=(this.min-a)/(c-a),a=(this.max-a)/(c-a),this.horiz&&!this.reversed||!this.horiz&&this.reversed?f.setRange(d,a):f.setRange(1-a,1-d)))}),t(h,"afterGetOffset",function(){var a=this.horiz?2:1,c=this.scrollbar;c&&(this.chart.scrollbarsOffsets=[0,0],this.chart.axisOffset[a]+=c.size+c.options.margin)}),
e.Scrollbar=n)});H(n,"parts/Navigator.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,h){function n(b){this.init(b)}var C=h.clamp,B=h.correctFloat,D=h.defined,E=h.destroyObjectProperties,t=h.erase,x=h.extend,w=h.isArray,f=h.isNumber,v=h.pick,p=h.splat,q=e.addEvent,k=e.Axis;h=e.Chart;var a=e.color,c=e.defaultOptions,m=e.hasTouch,G=e.isTouchDevice,d=e.merge,l=e.removeEvent,r=e.Scrollbar,y=e.Series,F=function(b){for(var g=[],z=1;z<arguments.length;z++)g[z-1]=arguments[z];g=[].filter.call(g,
f);if(g.length)return Math[b].apply(0,g)};var u="undefined"===typeof e.seriesTypes.areaspline?"line":"areaspline";x(c,{navigator:{height:40,margin:25,maskInside:!0,handles:{width:7,height:15,symbols:["navigator-handle","navigator-handle"],enabled:!0,lineWidth:1,backgroundColor:"#f2f2f2",borderColor:"#999999"},maskFill:a("#6685c2").setOpacity(.3).get(),outlineColor:"#cccccc",outlineWidth:1,series:{type:u,fillOpacity:.05,lineWidth:1,compare:null,dataGrouping:{approximation:"average",enabled:!0,groupPixelWidth:2,
smoothed:!0,units:[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1,2,3,4]],["week",[1,2,3]],["month",[1,3,6]],["year",null]]},dataLabels:{enabled:!1,zIndex:2},id:"highcharts-navigator-series",className:"highcharts-navigator-series",lineColor:null,marker:{enabled:!1},threshold:null},xAxis:{overscroll:0,className:"highcharts-navigator-xaxis",tickLength:0,lineWidth:0,gridLineColor:"#e6e6e6",gridLineWidth:1,tickPixelInterval:200,
labels:{align:"left",style:{color:"#999999"},x:3,y:-4},crosshair:!1},yAxis:{className:"highcharts-navigator-yaxis",gridLineWidth:0,startOnTick:!1,endOnTick:!1,minPadding:.1,maxPadding:.1,labels:{enabled:!1},crosshair:!1,title:{text:null},tickLength:0,tickWidth:0}}});e.Renderer.prototype.symbols["navigator-handle"]=function(b,g,z,d,a){b=a.width/2;g=Math.round(b/3)+.5;a=a.height;return["M",-b-1,.5,"L",b,.5,"L",b,a+.5,"L",-b-1,a+.5,"L",-b-1,.5,"M",-g,4,"L",-g,a-3,"M",g-1,4,"L",g-1,a-3]};k.prototype.toFixedRange=
function(b,g,z,a){var d=this.chart&&this.chart.fixedRange,c=(this.pointRange||0)/2;b=v(z,this.translate(b,!0,!this.horiz));g=v(a,this.translate(g,!0,!this.horiz));var A=d&&(g-b)/d;D(z)||(b=B(b+c));D(a)||(g=B(g-c));.7<A&&1.3>A&&(a?b=g-d:g=b+d);f(b)&&f(g)||(b=g=void 0);return{min:b,max:g}};n.prototype={drawHandle:function(b,g,z,a){var d=this.navigatorOptions.handles.height;this.handles[g][a](z?{translateX:Math.round(this.left+this.height/2),translateY:Math.round(this.top+parseInt(b,10)+.5-d)}:{translateX:Math.round(this.left+
parseInt(b,10)),translateY:Math.round(this.top+this.height/2-d/2-1)})},drawOutline:function(b,g,z,a){var d=this.navigatorOptions.maskInside,c=this.outline.strokeWidth(),A=c/2;c=c%2/2;var f=this.outlineHeight,l=this.scrollbarHeight,r=this.size,u=this.left-l,k=this.top;z?(u-=A,z=k+g+c,g=k+b+c,b=["M",u+f,k-l-c,"L",u+f,z,"L",u,z,"L",u,g,"L",u+f,g,"L",u+f,k+r+l].concat(d?["M",u+f,z-A,"L",u+f,g+A]:[])):(b+=u+l-c,g+=u+l-c,k+=A,b=["M",u,k,"L",b,k,"L",b,k+f,"L",g,k+f,"L",g,k,"L",u+r+2*l,k].concat(d?["M",b-
A,k,"L",g+A,k]:[]));this.outline[a]({d:b})},drawMasks:function(b,g,z,d){var a=this.left,c=this.top,A=this.height;if(z){var f=[a,a,a];var l=[c,c+b,c+g];var r=[A,A,A];var u=[b,g-b,this.size-g]}else f=[a,a+b,a+g],l=[c,c,c],r=[b,g-b,this.size-g],u=[A,A,A];this.shades.forEach(function(b,g){b[d]({x:f[g],y:l[g],width:r[g],height:u[g]})})},renderElements:function(){var b=this,g=b.navigatorOptions,a=g.maskInside,d=b.chart,c=d.renderer,f,l={cursor:d.inverted?"ns-resize":"ew-resize"};b.navigatorGroup=f=c.g("navigator").attr({zIndex:8,
visibility:"hidden"}).add();[!a,a,!a].forEach(function(a,z){b.shades[z]=c.rect().addClass("highcharts-navigator-mask"+(1===z?"-inside":"-outside")).add(f);d.styledMode||b.shades[z].attr({fill:a?g.maskFill:"rgba(0,0,0,0)"}).css(1===z&&l)});b.outline=c.path().addClass("highcharts-navigator-outline").add(f);d.styledMode||b.outline.attr({"stroke-width":g.outlineWidth,stroke:g.outlineColor});g.handles.enabled&&[0,1].forEach(function(a){g.handles.inverted=d.inverted;b.handles[a]=c.symbol(g.handles.symbols[a],
-g.handles.width/2-1,0,g.handles.width,g.handles.height,g.handles);b.handles[a].attr({zIndex:7-a}).addClass("highcharts-navigator-handle highcharts-navigator-handle-"+["left","right"][a]).add(f);if(!d.styledMode){var z=g.handles;b.handles[a].attr({fill:z.backgroundColor,stroke:z.borderColor,"stroke-width":z.lineWidth}).css(l)}})},update:function(b){(this.series||[]).forEach(function(b){b.baseSeries&&delete b.baseSeries.navigatorSeries});this.destroy();d(!0,this.chart.options.navigator,this.options,
b);this.init(this.chart)},render:function(b,g,a,d){var z=this.chart,c=this.scrollbarHeight,A,l=this.xAxis,r=l.pointRange||0;var u=l.fake?z.xAxis[0]:l;var k=this.navigatorEnabled,m,y=this.rendered;var e=z.inverted;var q=z.xAxis[0].minRange,p=z.xAxis[0].options.maxRange;if(!this.hasDragged||D(a)){b=B(b-r/2);g=B(g+r/2);if(!f(b)||!f(g))if(y)a=0,d=v(l.width,u.width);else return;this.left=v(l.left,z.plotLeft+c+(e?z.plotWidth:0));this.size=m=A=v(l.len,(e?z.plotHeight:z.plotWidth)-2*c);z=e?c:A+2*c;a=v(a,
l.toPixels(b,!0));d=v(d,l.toPixels(g,!0));f(a)&&Infinity!==Math.abs(a)||(a=0,d=z);b=l.toValue(a,!0);g=l.toValue(d,!0);var h=Math.abs(B(g-b));h<q?this.grabbedLeft?a=l.toPixels(g-q-r,!0):this.grabbedRight&&(d=l.toPixels(b+q+r,!0)):D(p)&&B(h-r)>p&&(this.grabbedLeft?a=l.toPixels(g-p-r,!0):this.grabbedRight&&(d=l.toPixels(b+p+r,!0)));this.zoomedMax=C(Math.max(a,d),0,m);this.zoomedMin=C(this.fixedWidth?this.zoomedMax-this.fixedWidth:Math.min(a,d),0,m);this.range=this.zoomedMax-this.zoomedMin;m=Math.round(this.zoomedMax);
a=Math.round(this.zoomedMin);k&&(this.navigatorGroup.attr({visibility:"visible"}),y=y&&!this.hasDragged?"animate":"attr",this.drawMasks(a,m,e,y),this.drawOutline(a,m,e,y),this.navigatorOptions.handles.enabled&&(this.drawHandle(a,0,e,y),this.drawHandle(m,1,e,y)));this.scrollbar&&(e?(e=this.top-c,u=this.left-c+(k||!u.opposite?0:(u.titleOffset||0)+u.axisTitleMargin),c=A+2*c):(e=this.top+(k?this.height:-c),u=this.left-c),this.scrollbar.position(u,e,z,c),this.scrollbar.setRange(this.zoomedMin/(A||1),this.zoomedMax/
(A||1)));this.rendered=!0}},addMouseEvents:function(){var b=this,g=b.chart,a=g.container,d=[],c,l;b.mouseMoveHandler=c=function(g){b.onMouseMove(g)};b.mouseUpHandler=l=function(g){b.onMouseUp(g)};d=b.getPartsEvents("mousedown");d.push(q(g.renderTo,"mousemove",c),q(a.ownerDocument,"mouseup",l));m&&(d.push(q(g.renderTo,"touchmove",c),q(a.ownerDocument,"touchend",l)),d.concat(b.getPartsEvents("touchstart")));b.eventsToUnbind=d;b.series&&b.series[0]&&d.push(q(b.series[0].xAxis,"foundExtremes",function(){g.navigator.modifyNavigatorAxisExtremes()}))},
getPartsEvents:function(b){var g=this,a=[];["shades","handles"].forEach(function(d){g[d].forEach(function(z,c){a.push(q(z.element,b,function(b){g[d+"Mousedown"](b,c)}))})});return a},shadesMousedown:function(b,g){b=this.chart.pointer.normalize(b);var a=this.chart,d=this.xAxis,c=this.zoomedMin,l=this.left,f=this.size,r=this.range,u=b.chartX;a.inverted&&(u=b.chartY,l=this.top);if(1===g)this.grabbedCenter=u,this.fixedWidth=r,this.dragOffset=u-c;else{b=u-l-r/2;if(0===g)b=Math.max(0,b);else if(2===g&&
b+r>=f)if(b=f-r,this.reversedExtremes){b-=r;var k=this.getUnionExtremes().dataMin}else var m=this.getUnionExtremes().dataMax;b!==c&&(this.fixedWidth=r,g=d.toFixedRange(b,b+r,k,m),D(g.min)&&a.xAxis[0].setExtremes(Math.min(g.min,g.max),Math.max(g.min,g.max),!0,null,{trigger:"navigator"}))}},handlesMousedown:function(b,g){this.chart.pointer.normalize(b);b=this.chart;var a=b.xAxis[0],d=this.reversedExtremes;0===g?(this.grabbedLeft=!0,this.otherHandlePos=this.zoomedMax,this.fixedExtreme=d?a.min:a.max):
(this.grabbedRight=!0,this.otherHandlePos=this.zoomedMin,this.fixedExtreme=d?a.max:a.min);b.fixedRange=null},onMouseMove:function(b){var g=this,a=g.chart,d=g.left,c=g.navigatorSize,l=g.range,f=g.dragOffset,r=a.inverted;b.touches&&0===b.touches[0].pageX||(b=a.pointer.normalize(b),a=b.chartX,r&&(d=g.top,a=b.chartY),g.grabbedLeft?(g.hasDragged=!0,g.render(0,0,a-d,g.otherHandlePos)):g.grabbedRight?(g.hasDragged=!0,g.render(0,0,g.otherHandlePos,a-d)):g.grabbedCenter&&(g.hasDragged=!0,a<f?a=f:a>c+f-l&&
(a=c+f-l),g.render(0,0,a-f,a-f+l)),g.hasDragged&&g.scrollbar&&v(g.scrollbar.options.liveRedraw,e.svg&&!G&&!this.chart.isBoosting)&&(b.DOMType=b.type,setTimeout(function(){g.onMouseUp(b)},0)))},onMouseUp:function(b){var g=this.chart,a=this.xAxis,d=this.scrollbar,c=b.DOMEvent||b;if(this.hasDragged&&(!d||!d.hasDragged)||"scrollbar"===b.trigger){d=this.getUnionExtremes();if(this.zoomedMin===this.otherHandlePos)var l=this.fixedExtreme;else if(this.zoomedMax===this.otherHandlePos)var f=this.fixedExtreme;
this.zoomedMax===this.size&&(f=this.reversedExtremes?d.dataMin:d.dataMax);0===this.zoomedMin&&(l=this.reversedExtremes?d.dataMax:d.dataMin);a=a.toFixedRange(this.zoomedMin,this.zoomedMax,l,f);D(a.min)&&g.xAxis[0].setExtremes(Math.min(a.min,a.max),Math.max(a.min,a.max),!0,this.hasDragged?!1:null,{trigger:"navigator",triggerOp:"navigator-drag",DOMEvent:c})}"mousemove"!==b.DOMType&&"touchmove"!==b.DOMType&&(this.grabbedLeft=this.grabbedRight=this.grabbedCenter=this.fixedWidth=this.fixedExtreme=this.otherHandlePos=
this.hasDragged=this.dragOffset=null)},removeEvents:function(){this.eventsToUnbind&&(this.eventsToUnbind.forEach(function(b){b()}),this.eventsToUnbind=void 0);this.removeBaseSeriesEvents()},removeBaseSeriesEvents:function(){var b=this.baseSeries||[];this.navigatorEnabled&&b[0]&&(!1!==this.navigatorOptions.adaptToUpdatedData&&b.forEach(function(b){l(b,"updatedData",this.updatedDataHandler)},this),b[0].xAxis&&l(b[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes))},init:function(b){var g=b.options,
a=g.navigator,c=a.enabled,l=g.scrollbar,f=l.enabled;g=c?a.height:0;var u=f?l.height:0;this.handles=[];this.shades=[];this.chart=b;this.setBaseSeries();this.height=g;this.scrollbarHeight=u;this.scrollbarEnabled=f;this.navigatorEnabled=c;this.navigatorOptions=a;this.scrollbarOptions=l;this.outlineHeight=g+u;this.opposite=v(a.opposite,!(c||!b.inverted));var m=this;c=m.baseSeries;l=b.xAxis.length;f=b.yAxis.length;var y=c&&c[0]&&c[0].xAxis||b.xAxis[0]||{options:{}};b.isDirtyBox=!0;m.navigatorEnabled?(m.xAxis=
new k(b,d({breaks:y.options.breaks,ordinal:y.options.ordinal},a.xAxis,{id:"navigator-x-axis",yAxis:"navigator-y-axis",isX:!0,type:"datetime",index:l,isInternal:!0,offset:0,keepOrdinalPadding:!0,startOnTick:!1,endOnTick:!1,minPadding:0,maxPadding:0,zoomEnabled:!1},b.inverted?{offsets:[u,0,-u,0],width:g}:{offsets:[0,-u,0,u],height:g})),m.yAxis=new k(b,d(a.yAxis,{id:"navigator-y-axis",alignTicks:!1,offset:0,index:f,isInternal:!0,zoomEnabled:!1},b.inverted?{width:g}:{height:g})),c||a.series.data?m.updateNavigatorSeries(!1):
0===b.series.length&&(m.unbindRedraw=q(b,"beforeRedraw",function(){0<b.series.length&&!m.series&&(m.setBaseSeries(),m.unbindRedraw())})),m.reversedExtremes=b.inverted&&!m.xAxis.reversed||!b.inverted&&m.xAxis.reversed,m.renderElements(),m.addMouseEvents()):m.xAxis={translate:function(g,a){var d=b.xAxis[0],c=d.getExtremes(),z=d.len-2*u,l=F("min",d.options.min,c.dataMin);d=F("max",d.options.max,c.dataMax)-l;return a?g*d/z+l:z*(g-l)/d},toPixels:function(b){return this.translate(b)},toValue:function(b){return this.translate(b,
!0)},toFixedRange:k.prototype.toFixedRange,fake:!0};b.options.scrollbar.enabled&&(b.scrollbar=m.scrollbar=new r(b.renderer,d(b.options.scrollbar,{margin:m.navigatorEnabled?0:10,vertical:b.inverted}),b),q(m.scrollbar,"changed",function(g){var a=m.size,d=a*this.to;a*=this.from;m.hasDragged=m.scrollbar.hasDragged;m.render(0,0,a,d);(b.options.scrollbar.liveRedraw||"mousemove"!==g.DOMType&&"touchmove"!==g.DOMType)&&setTimeout(function(){m.onMouseUp(g)})}));m.addBaseSeriesEvents();m.addChartEvents()},getUnionExtremes:function(b){var g=
this.chart.xAxis[0],a=this.xAxis,d=a.options,c=g.options,l;b&&null===g.dataMin||(l={dataMin:v(d&&d.min,F("min",c.min,g.dataMin,a.dataMin,a.min)),dataMax:v(d&&d.max,F("max",c.max,g.dataMax,a.dataMax,a.max))});return l},setBaseSeries:function(b,g){var a=this.chart,d=this.baseSeries=[];b=b||a.options&&a.options.navigator.baseSeries||(a.series.length?e.find(a.series,function(b){return!b.options.isInternal}).index:0);(a.series||[]).forEach(function(g,a){g.options.isInternal||!g.options.showInNavigator&&
(a!==b&&g.options.id!==b||!1===g.options.showInNavigator)||d.push(g)});this.xAxis&&!this.xAxis.fake&&this.updateNavigatorSeries(!0,g)},updateNavigatorSeries:function(b,g){var a=this,f=a.chart,r=a.baseSeries,u,k,m=a.navigatorOptions.series,y,e={enableMouseTracking:!1,index:null,linkedTo:null,group:"nav",padXAxis:!1,xAxis:"navigator-x-axis",yAxis:"navigator-y-axis",showInLegend:!1,stacking:!1,isInternal:!0,states:{inactive:{opacity:1}}},q=a.series=(a.series||[]).filter(function(b){var g=b.baseSeries;
return 0>r.indexOf(g)?(g&&(l(g,"updatedData",a.updatedDataHandler),delete g.navigatorSeries),b.chart&&b.destroy(),!1):!0});r&&r.length&&r.forEach(function(b){var l=b.navigatorSeries,z=x({color:b.color,visible:b.visible},w(m)?c.navigator.series:m);l&&!1===a.navigatorOptions.adaptToUpdatedData||(e.name="Navigator "+r.length,u=b.options||{},y=u.navigatorOptions||{},k=d(u,e,z,y),k.pointRange=v(z.pointRange,y.pointRange,c.plotOptions[k.type||"line"].pointRange),z=y.data||z.data,a.hasNavigatorData=a.hasNavigatorData||
!!z,k.data=z||u.data&&u.data.slice(0),l&&l.options?l.update(k,g):(b.navigatorSeries=f.initSeries(k),b.navigatorSeries.baseSeries=b,q.push(b.navigatorSeries)))});if(m.data&&(!r||!r.length)||w(m))a.hasNavigatorData=!1,m=p(m),m.forEach(function(b,g){e.name="Navigator "+(q.length+1);k=d(c.navigator.series,{color:f.series[g]&&!f.series[g].options.isInternal&&f.series[g].color||f.options.colors[g]||f.options.colors[0]},e,b);k.data=b.data;k.data&&(a.hasNavigatorData=!0,q.push(f.initSeries(k)))});b&&this.addBaseSeriesEvents()},
addBaseSeriesEvents:function(){var b=this,g=b.baseSeries||[];g[0]&&g[0].xAxis&&q(g[0].xAxis,"foundExtremes",this.modifyBaseAxisExtremes);g.forEach(function(g){q(g,"show",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!0,!1)});q(g,"hide",function(){this.navigatorSeries&&this.navigatorSeries.setVisible(!1,!1)});!1!==this.navigatorOptions.adaptToUpdatedData&&g.xAxis&&q(g,"updatedData",this.updatedDataHandler);q(g,"remove",function(){this.navigatorSeries&&(t(b.series,this.navigatorSeries),
D(this.navigatorSeries.options)&&this.navigatorSeries.remove(!1),delete this.navigatorSeries)})},this)},getBaseSeriesMin:function(b){return this.baseSeries.reduce(function(b,a){return Math.min(b,a.xData?a.xData[0]:b)},b)},modifyNavigatorAxisExtremes:function(){var b=this.xAxis,g;"undefined"!==typeof b.getExtremes&&(!(g=this.getUnionExtremes(!0))||g.dataMin===b.min&&g.dataMax===b.max||(b.min=g.dataMin,b.max=g.dataMax))},modifyBaseAxisExtremes:function(){var b=this.chart.navigator,g=this.getExtremes(),
a=g.dataMin,d=g.dataMax;g=g.max-g.min;var c=b.stickToMin,l=b.stickToMax,r=v(this.options.overscroll,0),u=b.series&&b.series[0],k=!!this.setExtremes;if(!this.eventArgs||"rangeSelectorButton"!==this.eventArgs.trigger){if(c){var m=a;var y=m+g}l&&(y=d+r,c||(m=Math.max(y-g,b.getBaseSeriesMin(u&&u.xData?u.xData[0]:-Number.MAX_VALUE))));k&&(c||l)&&f(m)&&(this.min=this.userMin=m,this.max=this.userMax=y)}b.stickToMin=b.stickToMax=null},updatedDataHandler:function(){var b=this.chart.navigator,g=this.navigatorSeries,
a=b.getBaseSeriesMin(this.xData[0]);b.stickToMax=b.reversedExtremes?0===Math.round(b.zoomedMin):Math.round(b.zoomedMax)>=Math.round(b.size);b.stickToMin=f(this.xAxis.min)&&this.xAxis.min<=a&&(!this.chart.fixedRange||!b.stickToMax);g&&!b.hasNavigatorData&&(g.options.pointStart=this.xData[0],g.setData(this.options.data,!1,null,!1))},addChartEvents:function(){this.eventsToUnbind||(this.eventsToUnbind=[]);this.eventsToUnbind.push(q(this.chart,"redraw",function(){var b=this.navigator,g=b&&(b.baseSeries&&
b.baseSeries[0]&&b.baseSeries[0].xAxis||b.scrollbar&&this.xAxis[0]);g&&b.render(g.min,g.max)}),q(this.chart,"getMargins",function(){var b=this.navigator,g=b.opposite?"plotTop":"marginBottom";this.inverted&&(g=b.opposite?"marginRight":"plotLeft");this[g]=(this[g]||0)+(b.navigatorEnabled||!this.inverted?b.outlineHeight:0)+b.navigatorOptions.margin}))},destroy:function(){this.removeEvents();this.xAxis&&(t(this.chart.xAxis,this.xAxis),t(this.chart.axes,this.xAxis));this.yAxis&&(t(this.chart.yAxis,this.yAxis),
t(this.chart.axes,this.yAxis));(this.series||[]).forEach(function(b){b.destroy&&b.destroy()});"series xAxis yAxis shades outline scrollbarTrack scrollbarRifles scrollbarGroup scrollbar navigatorGroup rendered".split(" ").forEach(function(b){this[b]&&this[b].destroy&&this[b].destroy();this[b]=null},this);[this.handles].forEach(function(b){E(b)},this)}};e.Navigator||(e.Navigator=n,q(k,"zoom",function(b){var g=this.chart.options,a=g.chart.zoomType,d=g.chart.pinchType,c=g.navigator;g=g.rangeSelector;
this.isXAxis&&(c&&c.enabled||g&&g.enabled)&&("y"===a?b.zoomed=!1:(!G&&"xy"===a||G&&"xy"===d)&&this.options.range&&(a=this.previousZoom,D(b.newMin)?this.previousZoom=[this.min,this.max]:a&&(b.newMin=a[0],b.newMax=a[1],delete this.previousZoom)));"undefined"!==typeof b.zoomed&&b.preventDefault()}),q(h,"beforeShowResetZoom",function(){var b=this.options,g=b.navigator,a=b.rangeSelector;if((g&&g.enabled||a&&a.enabled)&&(!G&&"x"===b.chart.zoomType||G&&"x"===b.chart.pinchType))return!1}),q(h,"beforeRender",
function(){var b=this.options;if(b.navigator.enabled||b.scrollbar.enabled)this.scroller=this.navigator=new n(this)}),q(h,"afterSetChartSize",function(){var b=this.legend,g=this.navigator;if(g){var a=b&&b.options;var d=g.xAxis;var c=g.yAxis;var l=g.scrollbarHeight;this.inverted?(g.left=g.opposite?this.chartWidth-l-g.height:this.spacing[3]+l,g.top=this.plotTop+l):(g.left=this.plotLeft+l,g.top=g.navigatorOptions.top||this.chartHeight-g.height-l-this.spacing[2]-(this.rangeSelector&&this.extraBottomMargin?
this.rangeSelector.getHeight():0)-(a&&"bottom"===a.verticalAlign&&a.enabled&&!a.floating?b.legendHeight+v(a.margin,10):0)-(this.titleOffset?this.titleOffset[2]:0));d&&c&&(this.inverted?d.options.left=c.options.left=g.left:d.options.top=c.options.top=g.top,d.setAxisSize(),c.setAxisSize())}}),q(h,"update",function(b){var a=b.options.navigator||{},c=b.options.scrollbar||{};this.navigator||this.scroller||!a.enabled&&!c.enabled||(d(!0,this.options.navigator,a),d(!0,this.options.scrollbar,c),delete b.options.navigator,
delete b.options.scrollbar)}),q(h,"afterUpdate",function(b){this.navigator||this.scroller||!this.options.navigator.enabled&&!this.options.scrollbar.enabled||(this.scroller=this.navigator=new n(this),v(b.redraw,!0)&&this.redraw(b.animation))}),q(h,"afterAddSeries",function(){this.navigator&&this.navigator.setBaseSeries(null,!1)}),q(y,"afterUpdate",function(){this.chart.navigator&&!this.options.isInternal&&this.chart.navigator.setBaseSeries(null,!1)}),h.prototype.callbacks.push(function(b){var a=b.navigator;
a&&b.xAxis[0]&&(b=b.xAxis[0].getExtremes(),a.render(b.min,b.max))}))});H(n,"parts/OrdinalAxis.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,h){var n=h.defined,C=h.extend,B=h.pick;h=e.addEvent;var D=e.Axis,E=e.Chart,t=e.css,x=e.noop,w=e.timeUnits;h(e.Series,"updatedData",function(){var f=this.xAxis;f&&f.options.ordinal&&delete f.ordinalIndex});D.prototype.getTimeTicks=function(f,v,e,q,k,a,c){var m=0,p,d,l={},r=[],y=-Number.MAX_VALUE,h=this.options.tickPixelInterval,u=this.chart.time,
b=[];if(!this.options.ordinal&&!this.options.breaks||!k||3>k.length||"undefined"===typeof v)return u.getTimeTicks.apply(u,arguments);var g=k.length;for(p=0;p<g;p++){var z=p&&k[p-1]>e;k[p]<v&&(m=p);if(p===g-1||k[p+1]-k[p]>5*a||z){if(k[p]>y){for(d=u.getTimeTicks(f,k[m],k[p],q);d.length&&d[0]<=y;)d.shift();d.length&&(y=d[d.length-1]);b.push(r.length);r=r.concat(d)}m=p+1}if(z)break}d=d.info;if(c&&d.unitRange<=w.hour){p=r.length-1;for(m=1;m<p;m++)if(u.dateFormat("%d",r[m])!==u.dateFormat("%d",r[m-1])){l[r[m]]=
"day";var A=!0}A&&(l[r[0]]="day");d.higherRanks=l}d.segmentStarts=b;r.info=d;if(c&&n(h)){m=b=r.length;A=[];var J;for(u=[];m--;)p=this.translate(r[m]),J&&(u[m]=J-p),A[m]=J=p;u.sort();u=u[Math.floor(u.length/2)];u<.6*h&&(u=null);m=r[b-1]>e?b-1:b;for(J=void 0;m--;)p=A[m],b=Math.abs(J-p),J&&b<.8*h&&(null===u||b<.8*u)?(l[r[m]]&&!l[r[m+1]]?(b=m+1,J=p):b=m,r.splice(b,1)):J=p}return r};C(D.prototype,{beforeSetTickPositions:function(){var f=[],e,p=!1,q=this.getExtremes(),k=q.min,a=q.max,c,m=this.isXAxis&&
!!this.options.breaks;q=this.options.ordinal;var h=Number.MAX_VALUE,d=this.chart.options.chart.ignoreHiddenSeries,l;if(q||m){this.series.forEach(function(a,c){e=[];if(!(d&&!1===a.visible||!1===a.takeOrdinalPosition&&!m)&&(f=f.concat(a.processedXData),r=f.length,f.sort(function(b,a){return b-a}),h=Math.min(h,B(a.closestPointRange,h)),r)){for(c=0;c<r-1;)f[c]!==f[c+1]&&e.push(f[c+1]),c++;e[0]!==f[0]&&e.unshift(f[0]);f=e}a.isSeriesBoosting&&(l=!0)});l&&(f.length=0);var r=f.length;if(2<r){var y=f[1]-f[0];
for(c=r-1;c--&&!p;)f[c+1]-f[c]!==y&&(p=!0);!this.options.keepOrdinalPadding&&(f[0]-k>y||a-f[f.length-1]>y)&&(p=!0)}else this.options.overscroll&&(2===r?h=f[1]-f[0]:1===r?(h=this.options.overscroll,f=[f[0],f[0]+h]):h=this.overscrollPointsRange);p?(this.options.overscroll&&(this.overscrollPointsRange=h,f=f.concat(this.getOverscrollPositions())),this.ordinalPositions=f,y=this.ordinal2lin(Math.max(k,f[0]),!0),c=Math.max(this.ordinal2lin(Math.min(a,f[f.length-1]),!0),1),this.ordinalSlope=a=(a-k)/(c-y),
this.ordinalOffset=k-y*a):(this.overscrollPointsRange=B(this.closestPointRange,this.overscrollPointsRange),this.ordinalPositions=this.ordinalSlope=this.ordinalOffset=void 0)}this.isOrdinal=q&&p;this.groupIntervalFactor=null},val2lin:function(f,e){var p=this.ordinalPositions;if(p){var v=p.length,k;for(k=v;k--;)if(p[k]===f){var a=k;break}for(k=v-1;k--;)if(f>p[k]||0===k){f=(f-p[k])/(p[k+1]-p[k]);a=k+f;break}e=e?a:this.ordinalSlope*(a||0)+this.ordinalOffset}else e=f;return e},lin2val:function(f,e){var p=
this.ordinalPositions;if(p){var h=this.ordinalSlope,k=this.ordinalOffset,a=p.length-1;if(e)if(0>f)f=p[0];else if(f>a)f=p[a];else{a=Math.floor(f);var c=f-a}else for(;a--;)if(e=h*a+k,f>=e){h=h*(a+1)+k;c=(f-e)/(h-e);break}return"undefined"!==typeof c&&"undefined"!==typeof p[a]?p[a]+(c?c*(p[a+1]-p[a]):0):f}return f},getExtendedPositions:function(){var f=this,e=f.chart,p=f.series[0].currentDataGrouping,h=f.ordinalIndex,k=p?p.count+p.unitName:"raw",a=f.options.overscroll,c=f.getExtremes(),m;h||(h=f.ordinalIndex=
{});if(!h[k]){var t={series:[],chart:e,getExtremes:function(){return{min:c.dataMin,max:c.dataMax+a}},options:{ordinal:!0},val2lin:D.prototype.val2lin,ordinal2lin:D.prototype.ordinal2lin};f.series.forEach(function(a){m={xAxis:t,xData:a.xData.slice(),chart:e,destroyGroupedData:x};m.xData=m.xData.concat(f.getOverscrollPositions());m.options={dataGrouping:p?{enabled:!0,forced:!0,approximation:"open",units:[[p.unitName,[p.count]]]}:{enabled:!1}};a.processData.apply(m);t.series.push(m)});f.beforeSetTickPositions.apply(t);
h[k]=t.ordinalPositions}return h[k]},getOverscrollPositions:function(){var f=this.options.overscroll,e=this.overscrollPointsRange,p=[],h=this.dataMax;if(n(e))for(p.push(h);h<=this.dataMax+f;)h+=e,p.push(h);return p},getGroupIntervalFactor:function(f,e,h){h=h.processedXData;var p=h.length,k=[];var a=this.groupIntervalFactor;if(!a){for(a=0;a<p-1;a++)k[a]=h[a+1]-h[a];k.sort(function(a,f){return a-f});k=k[Math.floor(p/2)];f=Math.max(f,h[0]);e=Math.min(e,h[p-1]);this.groupIntervalFactor=a=p*k/(e-f)}return a},
postProcessTickInterval:function(f){var e=this.ordinalSlope;return e?this.options.breaks?this.closestPointRange||f:f/(e/this.closestPointRange):f}});D.prototype.ordinal2lin=D.prototype.val2lin;h(E,"pan",function(f){var e=this.xAxis[0],h=e.options.overscroll,q=f.originalEvent.chartX,k=this.options.chart&&this.options.chart.panning,a=!1;if(k&&"y"!==k.type&&e.options.ordinal&&e.series.length){var c=this.mouseDownX,m=e.getExtremes(),D=m.dataMax,d=m.min,l=m.max,r=this.hoverPoints,y=e.closestPointRange||
e.overscrollPointsRange;c=(c-q)/(e.translationSlope*(e.ordinalSlope||y));var F={ordinalPositions:e.getExtendedPositions()};y=e.lin2val;var u=e.val2lin;if(!F.ordinalPositions)a=!0;else if(1<Math.abs(c)){r&&r.forEach(function(b){b.setState()});if(0>c){r=F;var b=e.ordinalPositions?e:F}else r=e.ordinalPositions?e:F,b=F;F=b.ordinalPositions;D>F[F.length-1]&&F.push(D);this.fixedRange=l-d;c=e.toFixedRange(null,null,y.apply(r,[u.apply(r,[d,!0])+c,!0]),y.apply(b,[u.apply(b,[l,!0])+c,!0]));c.min>=Math.min(m.dataMin,
d)&&c.max<=Math.max(D,l)+h&&e.setExtremes(c.min,c.max,!0,!1,{trigger:"pan"});this.mouseDownX=q;t(this.container,{cursor:"move"})}}else a=!0;a||k&&/y/.test(k.type)?h&&(e.max=e.dataMax+h):f.preventDefault()});h(D,"foundExtremes",function(){this.isXAxis&&n(this.options.overscroll)&&this.max===this.dataMax&&(!this.chart.mouseIsDown||this.isInternal)&&(!this.eventArgs||this.eventArgs&&"navigator"!==this.eventArgs.trigger)&&(this.max+=this.options.overscroll,!this.isInternal&&n(this.userMin)&&(this.min+=
this.options.overscroll))});h(D,"afterSetScale",function(){this.horiz&&!this.isDirty&&(this.isDirty=this.isOrdinal&&this.chart.navigator&&!this.chart.navigator.adaptToUpdatedData)})});H(n,"modules/broken-axis.src.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,h){var n=h.extend,C=h.isArray,B=h.pick;h=e.addEvent;var D=e.find,E=e.fireEvent,t=e.Axis,x=e.Series,w=function(f,e){return D(e,function(e){return e.from<f&&f<e.to})};n(t.prototype,{isInBreak:function(f,e){var h=f.repeat||Infinity,
q=f.from,k=f.to-f.from;e=e>=q?(e-q)%h:h-(q-e)%h;return f.inclusive?e<=k:e<k&&0!==e},isInAnyBreak:function(f,e){var h=this.options.breaks,q=h&&h.length,k;if(q){for(;q--;)if(this.isInBreak(h[q],f)){var a=!0;k||(k=B(h[q].showPoints,!this.isXAxis))}var c=a&&e?a&&!k:a}return c}});h(t,"afterInit",function(){"function"===typeof this.setBreaks&&this.setBreaks(this.options.breaks,!1)});h(t,"afterSetTickPositions",function(){if(this.isBroken){var f=this.tickPositions,e=this.tickPositions.info,h=[],q;for(q=
0;q<f.length;q++)this.isInAnyBreak(f[q])||h.push(f[q]);this.tickPositions=h;this.tickPositions.info=e}});h(t,"afterSetOptions",function(){this.isBroken&&(this.options.ordinal=!1)});t.prototype.setBreaks=function(f,e){function h(a){var c=a,f;for(f=0;f<k.breakArray.length;f++){var d=k.breakArray[f];if(d.to<=a)c-=d.len;else if(d.from>=a)break;else if(k.isInBreak(d,a)){c-=a-d.from;break}}return c}function q(a){var c;for(c=0;c<k.breakArray.length;c++){var f=k.breakArray[c];if(f.from>=a)break;else f.to<
a?a+=f.len:k.isInBreak(f,a)&&(a+=f.len)}return a}var k=this,a=C(f)&&!!f.length;k.isDirty=k.isBroken!==a;k.isBroken=a;k.options.breaks=k.userOptions.breaks=f;k.forceRedraw=!0;k.series.forEach(function(a){a.isDirty=!0});a||k.val2lin!==h||(delete k.val2lin,delete k.lin2val);a&&(k.userOptions.ordinal=!1,k.val2lin=h,k.lin2val=q,k.setExtremes=function(a,f,e,d,l){if(this.isBroken){for(var c,k=this.options.breaks;c=w(a,k);)a=c.to;for(;c=w(f,k);)f=c.from;f<a&&(f=a)}t.prototype.setExtremes.call(this,a,f,e,
d,l)},k.setAxisTranslation=function(a){t.prototype.setAxisTranslation.call(this,a);this.unitLength=null;if(this.isBroken){a=k.options.breaks;var c=[],f=[],d=0,l,r=k.userMin||k.min,e=k.userMax||k.max,h=B(k.pointRangePadding,0),u;a.forEach(function(b){l=b.repeat||Infinity;k.isInBreak(b,r)&&(r+=b.to%l-r%l);k.isInBreak(b,e)&&(e-=e%l-b.from%l)});a.forEach(function(b){g=b.from;for(l=b.repeat||Infinity;g-l>r;)g-=l;for(;g<r;)g+=l;for(u=g;u<e;u+=l)c.push({value:u,move:"in"}),c.push({value:u+(b.to-b.from),
move:"out",size:b.breakSize})});c.sort(function(b,a){return b.value===a.value?("in"===b.move?0:1)-("in"===a.move?0:1):b.value-a.value});var b=0;var g=r;c.forEach(function(a){b+="in"===a.move?1:-1;1===b&&"in"===a.move&&(g=a.value);0===b&&(f.push({from:g,to:a.value,len:a.value-g-(a.size||0)}),d+=a.value-g-(a.size||0))});k.breakArray=f;k.unitLength=e-r-d+h;E(k,"afterBreaks");k.staticScale?k.transA=k.staticScale:k.unitLength&&(k.transA*=(e-k.min+h)/k.unitLength);h&&(k.minPixelPadding=k.transA*k.minPointOffset);
k.min=r;k.max=e}});B(e,!0)&&this.chart.redraw()};h(x,"afterGeneratePoints",function(){var f=this.options.connectNulls,e=this.points,h=this.xAxis,q=this.yAxis;if(this.isDirty)for(var k=e.length;k--;){var a=e[k],c=!(null===a.y&&!1===f)&&(h&&h.isInAnyBreak(a.x,!0)||q&&q.isInAnyBreak(a.y,!0));a.visible=c?!1:!1!==a.options.visible}});h(x,"afterRender",function(){this.drawBreaks(this.xAxis,["x"]);this.drawBreaks(this.yAxis,B(this.pointArrayMap,["y"]))});e.Series.prototype.drawBreaks=function(f,e){var h=
this,q=h.points,k,a,c,m;f&&e.forEach(function(e){k=f.breakArray||[];a=f.isXAxis?f.min:B(h.options.threshold,f.min);q.forEach(function(d){m=B(d["stack"+e.toUpperCase()],d[e]);k.forEach(function(l){c=!1;if(a<l.from&&m>l.to||a>l.from&&m<l.from)c="pointBreak";else if(a<l.from&&m>l.from&&m<l.to||a>l.from&&m>l.to&&m<l.from)c="pointInBreak";c&&E(f,c,{point:d,brk:l})})})})};e.Series.prototype.gappedPath=function(){var f=this.currentDataGrouping,h=f&&f.gapSize;f=this.options.gapSize;var p=this.points.slice(),
q=p.length-1,k=this.yAxis,a;if(f&&0<q)for("value"!==this.options.gapUnit&&(f*=this.basePointRange),h&&h>f&&h>=this.basePointRange&&(f=h),a=void 0;q--;)a&&!1!==a.visible||(a=p[q+1]),h=p[q],!1!==a.visible&&!1!==h.visible&&(a.x-h.x>f&&(a=(h.x+a.x)/2,p.splice(q+1,0,{isNull:!0,x:a}),this.options.stacking&&(a=k.stacks[this.stackKey][a]=new e.StackItem(k,k.options.stackLabels,!1,a,this.stack),a.total=0)),a=h);return this.getGraphPath(p)}});H(n,"masters/modules/broken-axis.src.js",[],function(){});H(n,"parts/DataGrouping.js",
[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,h){var n=h.arrayMax,C=h.arrayMin,B=h.correctFloat,D=h.defined,E=h.extend,t=h.isNumber,x=h.pick;h=e.addEvent;var w=e.Axis,f=e.defaultPlotOptions,v=e.format,p=e.merge,q=e.Point,k=e.Series,a=e.Tooltip,c=e.approximations={sum:function(b){var a=b.length;if(!a&&b.hasNulls)var d=null;else if(a)for(d=0;a--;)d+=b[a];return d},average:function(b){var a=b.length;b=c.sum(b);t(b)&&a&&(b=B(b/a));return b},averages:function(){var b=[];[].forEach.call(arguments,
function(a){b.push(c.average(a))});return"undefined"===typeof b[0]?void 0:b},open:function(b){return b.length?b[0]:b.hasNulls?null:void 0},high:function(b){return b.length?n(b):b.hasNulls?null:void 0},low:function(b){return b.length?C(b):b.hasNulls?null:void 0},close:function(b){return b.length?b[b.length-1]:b.hasNulls?null:void 0},ohlc:function(b,a,d,f){b=c.open(b);a=c.high(a);d=c.low(d);f=c.close(f);if(t(b)||t(a)||t(d)||t(f))return[b,a,d,f]},range:function(b,a){b=c.low(b);a=c.high(a);if(t(b)||t(a))return[b,
a];if(null===b&&null===a)return null}},m=function(b,a,d,f){var g=this,l=g.data,e=g.options&&g.options.data,r=[],u=[],k=[],h=b.length,m=!!a,z=[],A=g.pointArrayMap,y=A&&A.length,q=["x"].concat(A||["y"]),F=0,v=0,w;f="function"===typeof f?f:c[f]?c[f]:c[g.getDGApproximation&&g.getDGApproximation()||"average"];y?A.forEach(function(){z.push([])}):z.push([]);var n=y||1;for(w=0;w<=h&&!(b[w]>=d[0]);w++);for(w;w<=h;w++){for(;"undefined"!==typeof d[F+1]&&b[w]>=d[F+1]||w===h;){var x=d[F];g.dataGroupInfo={start:g.cropStart+
v,length:z[0].length};var E=f.apply(g,z);g.pointClass&&!D(g.dataGroupInfo.options)&&(g.dataGroupInfo.options=p(g.pointClass.prototype.optionsToObject.call({series:g},g.options.data[g.cropStart+v])),q.forEach(function(b){delete g.dataGroupInfo.options[b]}));"undefined"!==typeof E&&(r.push(x),u.push(E),k.push(g.dataGroupInfo));v=w;for(x=0;x<n;x++)z[x].length=0,z[x].hasNulls=!1;F+=1;if(w===h)break}if(w===h)break;if(A)for(x=g.cropStart+w,E=l&&l[x]||g.pointClass.prototype.applyOptions.apply({series:g},
[e[x]]),x=0;x<y;x++){var B=E[A[x]];t(B)?z[x].push(B):null===B&&(z[x].hasNulls=!0)}else x=m?a[w]:null,t(x)?z[0].push(x):null===x&&(z[0].hasNulls=!0)}return{groupedXData:r,groupedYData:u,groupMap:k}},G={approximations:c,groupData:m},d=k.prototype,l=d.processData,r=d.generatePoints,y={groupPixelWidth:2,dateTimeLabelFormats:{millisecond:["%A, %b %e, %H:%M:%S.%L","%A, %b %e, %H:%M:%S.%L","-%H:%M:%S.%L"],second:["%A, %b %e, %H:%M:%S","%A, %b %e, %H:%M:%S","-%H:%M:%S"],minute:["%A, %b %e, %H:%M","%A, %b %e, %H:%M",
"-%H:%M"],hour:["%A, %b %e, %H:%M","%A, %b %e, %H:%M","-%H:%M"],day:["%A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],week:["Week from %A, %b %e, %Y","%A, %b %e","-%A, %b %e, %Y"],month:["%B %Y","%B","-%B %Y"],year:["%Y","%Y","-%Y"]}},F={line:{},spline:{},area:{},areaspline:{},arearange:{},column:{groupPixelWidth:10},columnrange:{groupPixelWidth:10},candlestick:{groupPixelWidth:10},ohlc:{groupPixelWidth:5}},u=e.defaultDataGroupingUnits=[["millisecond",[1,2,5,10,20,25,50,100,200,500]],["second",[1,2,
5,10,15,30]],["minute",[1,2,5,10,15,30]],["hour",[1,2,3,4,6,8,12]],["day",[1]],["week",[1]],["month",[1,3,6]],["year",null]];d.getDGApproximation=function(){return e.seriesTypes.arearange&&this instanceof e.seriesTypes.arearange?"range":e.seriesTypes.ohlc&&this instanceof e.seriesTypes.ohlc?"ohlc":e.seriesTypes.column&&this instanceof e.seriesTypes.column?"sum":"average"};d.groupData=m;d.processData=function(){var b=this.chart,a=this.options.dataGrouping,c=!1!==this.allowDG&&a&&x(a.enabled,b.options.isStock),
f=this.visible||!b.options.chart.ignoreHiddenSeries,e,r=this.currentDataGrouping,k=!1;this.forceCrop=c;this.groupPixelWidth=null;this.hasProcessed=!0;c&&!this.requireSorting&&(this.requireSorting=k=!0);c=!1===l.apply(this,arguments)||!c;k&&(this.requireSorting=!1);if(!c){this.destroyGroupedData();c=a.groupAll?this.xData:this.processedXData;var h=a.groupAll?this.yData:this.processedYData,m=b.plotSizeX;b=this.xAxis;var y=b.options.ordinal,p=this.groupPixelWidth=b.getGroupPixelWidth&&b.getGroupPixelWidth();
if(p){this.isDirty=e=!0;this.points=null;k=b.getExtremes();var q=k.min;k=k.max;y=y&&b.getGroupIntervalFactor(q,k,this)||1;p=p*(k-q)/m*y;m=b.getTimeTicks(b.normalizeTimeTickInterval(p,a.units||u),Math.min(q,c[0]),Math.max(k,c[c.length-1]),b.options.startOfWeek,c,this.closestPointRange);h=d.groupData.apply(this,[c,h,m,a.approximation]);c=h.groupedXData;y=h.groupedYData;var F=0;if(a.smoothed&&c.length){var t=c.length-1;for(c[t]=Math.min(c[t],k);t--&&0<t;)c[t]+=p/2;c[0]=Math.max(c[0],q)}for(t=1;t<m.length;t++)m.info.segmentStarts&&
-1!==m.info.segmentStarts.indexOf(t)||(F=Math.max(m[t]-m[t-1],F));q=m.info;q.gapSize=F;this.closestPointRange=m.info.totalRange;this.groupMap=h.groupMap;if(D(c[0])&&c[0]<b.min&&f){if(!D(b.options.min)&&b.min<=b.dataMin||b.min===b.dataMin)b.min=Math.min(c[0],b.min);b.dataMin=Math.min(c[0],b.dataMin)}a.groupAll&&(a=this.cropData(c,y,b.min,b.max,1),c=a.xData,y=a.yData);this.processedXData=c;this.processedYData=y}else this.groupMap=null;this.hasGroupedData=e;this.currentDataGrouping=q;this.preventGraphAnimation=
(r&&r.totalRange)!==(q&&q.totalRange)}};d.destroyGroupedData=function(){this.groupedData&&(this.groupedData.forEach(function(b,a){b&&(this.groupedData[a]=b.destroy?b.destroy():null)},this),this.groupedData.length=0)};d.generatePoints=function(){r.apply(this);this.destroyGroupedData();this.groupedData=this.hasGroupedData?this.points:null};h(q,"update",function(){if(this.dataGroup)return e.error(24,!1,this.series.chart),!1});h(a,"headerFormatter",function(a){var b=this.chart,d=b.time,c=a.labelConfig,
f=c.series,l=f.tooltipOptions,e=f.options.dataGrouping,r=l.xDateFormat,k=f.xAxis,u=l[(a.isFooter?"footer":"header")+"Format"];if(k&&"datetime"===k.options.type&&e&&t(c.key)){var h=f.currentDataGrouping;e=e.dateTimeLabelFormats||y.dateTimeLabelFormats;if(h)if(l=e[h.unitName],1===h.count)r=l[0];else{r=l[1];var m=l[2]}else!r&&e&&(r=this.getXDateFormat(c,l,k));r=d.dateFormat(r,c.key);m&&(r+=d.dateFormat(m,c.key+h.totalRange-1));f.chart.styledMode&&(u=this.styledModeFormat(u));a.text=v(u,{point:E(c.point,
{key:r}),series:f},b);a.preventDefault()}});h(k,"destroy",d.destroyGroupedData);h(k,"afterSetOptions",function(a){a=a.options;var b=this.type,d=this.chart.options.plotOptions,c=f[b].dataGrouping,l=this.useCommonDataGrouping&&y;if(F[b]||l)c||(c=p(y,F[b])),a.dataGrouping=p(l,c,d.series&&d.series.dataGrouping,d[b].dataGrouping,this.userOptions.dataGrouping)});h(w,"afterSetScale",function(){this.series.forEach(function(a){a.hasProcessed=!1})});w.prototype.getGroupPixelWidth=function(){var a=this.series,
g=a.length,d,c=0,f=!1,l;for(d=g;d--;)(l=a[d].options.dataGrouping)&&(c=Math.max(c,x(l.groupPixelWidth,y.groupPixelWidth)));for(d=g;d--;)(l=a[d].options.dataGrouping)&&a[d].hasProcessed&&(g=(a[d].processedXData||a[d].data).length,a[d].groupPixelWidth||g>this.chart.plotSizeX/c||g&&l.forced)&&(f=!0);return f?c:0};w.prototype.setDataGrouping=function(a,d){var b;d=x(d,!0);a||(a={forced:!1,units:null});if(this instanceof w)for(b=this.series.length;b--;)this.series[b].update({dataGrouping:a},!1);else this.chart.options.series.forEach(function(b){b.dataGrouping=
a},!1);this.ordinalSlope=null;d&&this.chart.redraw()};e.dataGrouping=G;"";return G});H(n,"parts/OHLCSeries.js",[n["parts/Globals.js"]],function(e){var h=e.Point,n=e.seriesType,C=e.seriesTypes;n("ohlc","column",{lineWidth:1,tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Open: {point.open}<br/>High: {point.high}<br/>Low: {point.low}<br/>Close: {point.close}<br/>'},threshold:null,states:{hover:{lineWidth:3}},stickyTracking:!0},{directTouch:!1,pointArrayMap:["open",
"high","low","close"],toYData:function(e){return[e.open,e.high,e.low,e.close]},pointValKey:"close",pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"},init:function(){C.column.prototype.init.apply(this,arguments);this.options.stacking=!1},pointAttribs:function(e,h){h=C.column.prototype.pointAttribs.call(this,e,h);var n=this.options;delete h.fill;!e.options.color&&n.upColor&&e.open<e.close&&(h.stroke=n.upColor);return h},translate:function(){var e=this,h=e.yAxis,n=!!e.modifyValue,t=["plotOpen",
"plotHigh","plotLow","plotClose","yBottom"];C.column.prototype.translate.apply(e);e.points.forEach(function(x){[x.open,x.high,x.low,x.close,x.low].forEach(function(w,f){null!==w&&(n&&(w=e.modifyValue(w)),x[t[f]]=h.toPixels(w,!0))});x.tooltipPos[1]=x.plotHigh+h.pos-e.chart.plotTop})},drawPoints:function(){var e=this,h=e.chart;e.points.forEach(function(n){var t=n.graphic,x=!t;if("undefined"!==typeof n.plotY){t||(n.graphic=t=h.renderer.path().add(e.group));h.styledMode||t.attr(e.pointAttribs(n,n.selected&&
"select"));var w=t.strokeWidth()%2/2;var f=Math.round(n.plotX)-w;var v=Math.round(n.shapeArgs.width/2);var p=["M",f,Math.round(n.yBottom),"L",f,Math.round(n.plotHigh)];if(null!==n.open){var q=Math.round(n.plotOpen)+w;p.push("M",f,q,"L",f-v,q)}null!==n.close&&(q=Math.round(n.plotClose)+w,p.push("M",f,q,"L",f+v,q));t[x?"attr":"animate"]({d:p}).addClass(n.getClassName(),!0)}})},animate:null},{getClassName:function(){return h.prototype.getClassName.call(this)+(this.open<this.close?" highcharts-point-up":
" highcharts-point-down")}});""});H(n,"parts/CandlestickSeries.js",[n["parts/Globals.js"]],function(e){var h=e.defaultPlotOptions,n=e.merge,C=e.seriesType,B=e.seriesTypes;C("candlestick","ohlc",n(h.column,{states:{hover:{lineWidth:2}},tooltip:h.ohlc.tooltip,threshold:null,lineColor:"#000000",lineWidth:1,upColor:"#ffffff",stickyTracking:!0}),{pointAttribs:function(e,h){var t=B.column.prototype.pointAttribs.call(this,e,h),n=this.options,w=e.open<e.close,f=n.lineColor||this.color;t["stroke-width"]=n.lineWidth;
t.fill=e.options.color||(w?n.upColor||this.color:this.color);t.stroke=e.options.lineColor||(w?n.upLineColor||f:f);h&&(e=n.states[h],t.fill=e.color||t.fill,t.stroke=e.lineColor||t.stroke,t["stroke-width"]=e.lineWidth||t["stroke-width"]);return t},drawPoints:function(){var e=this,h=e.chart,t=e.yAxis.reversed;e.points.forEach(function(n){var w=n.graphic,f=!w;if("undefined"!==typeof n.plotY){w||(n.graphic=w=h.renderer.path().add(e.group));e.chart.styledMode||w.attr(e.pointAttribs(n,n.selected&&"select")).shadow(e.options.shadow);
var v=w.strokeWidth()%2/2;var p=Math.round(n.plotX)-v;var q=n.plotOpen;var k=n.plotClose;var a=Math.min(q,k);q=Math.max(q,k);var c=Math.round(n.shapeArgs.width/2);k=t?q!==n.yBottom:Math.round(a)!==Math.round(n.plotHigh);var m=t?Math.round(a)!==Math.round(n.plotHigh):q!==n.yBottom;a=Math.round(a)+v;q=Math.round(q)+v;v=[];v.push("M",p-c,q,"L",p-c,a,"L",p+c,a,"L",p+c,q,"Z","M",p,a,"L",p,k?Math.round(t?n.yBottom:n.plotHigh):a,"M",p,q,"L",p,m?Math.round(t?n.plotHigh:n.yBottom):q);w[f?"attr":"animate"]({d:v}).addClass(n.getClassName(),
!0)}})}});""});H(n,"mixins/on-series.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,h){var n=h.defined,C=e.seriesTypes,B=e.stableSort;return{getPlotBox:function(){return e.Series.prototype.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this)},translate:function(){C.column.prototype.translate.apply(this);var e=this,h=e.options,t=e.chart,x=e.points,w=x.length-1,f,v=h.onSeries;v=v&&t.get(v);h=h.onKey||"y";var p=v&&v.options.step,q=v&&v.points,k=q&&q.length,
a=t.inverted,c=e.xAxis,m=e.yAxis,G=0,d;if(v&&v.visible&&k){G=(v.pointXOffset||0)+(v.barW||0)/2;t=v.currentDataGrouping;var l=q[k-1].x+(t?t.totalRange:0);B(x,function(a,d){return a.x-d.x});for(h="plot"+h[0].toUpperCase()+h.substr(1);k--&&x[w];){var r=q[k];t=x[w];t.y=r.y;if(r.x<=t.x&&"undefined"!==typeof r[h]){if(t.x<=l&&(t.plotY=r[h],r.x<t.x&&!p&&(d=q[k+1])&&"undefined"!==typeof d[h])){var y=(t.x-r.x)/(d.x-r.x);t.plotY+=y*(d[h]-r[h]);t.y+=y*(d.y-r.y)}w--;k++;if(0>w)break}}}x.forEach(function(d,l){d.plotX+=
G;if("undefined"===typeof d.plotY||a)0<=d.plotX&&d.plotX<=c.len?a?(d.plotY=c.translate(d.x,0,1,0,1),d.plotX=n(d.y)?m.translate(d.y,0,0,0,1):0):d.plotY=(c.opposite?0:e.yAxis.len)+c.offset:d.shapeArgs={};if((f=x[l-1])&&f.plotX===d.plotX){"undefined"===typeof f.stackIndex&&(f.stackIndex=0);var b=f.stackIndex+1}d.stackIndex=b});this.onSeries=v}}});H(n,"parts/FlagsSeries.js",[n["parts/Globals.js"],n["parts/Utilities.js"],n["mixins/on-series.js"]],function(e,h,n){function C(c){a[c+"pin"]=function(f,e,d,
l,h){var r=h&&h.anchorX;h=h&&h.anchorY;"circle"===c&&l>d&&(f-=Math.round((l-d)/2),d=l);var k=a[c](f,e,d,l);r&&h&&(k.push("M","circle"===c?f+d/2:k[1]+k[4]/2,e>h?e:e+l,"L",r,h),k=k.concat(a.circle(r-1,h-1,2,2)));return k}}var B=h.defined,D=h.isNumber,E=h.objectEach,t=h.wrap,x=e.addEvent,w=e.merge;h=e.noop;var f=e.Renderer,v=e.Series,p=e.seriesType,q=e.TrackerMixin,k=e.VMLRenderer,a=e.SVGRenderer.prototype.symbols;p("flags","column",{pointRange:0,allowOverlapX:!1,shape:"flag",stackDistance:12,textAlign:"center",
tooltip:{pointFormat:"{point.text}<br/>"},threshold:null,y:-30,fillColor:"#ffffff",lineWidth:1,states:{hover:{lineColor:"#000000",fillColor:"#ccd6eb"}},style:{fontSize:"11px",fontWeight:"bold"}},{sorted:!1,noSharedTooltip:!0,allowDG:!1,takeOrdinalPosition:!1,trackerGroups:["markerGroup"],forceCrop:!0,init:v.prototype.init,pointAttribs:function(a,f){var c=this.options,d=a&&a.color||this.color,e=c.lineColor,h=a&&a.lineWidth;a=a&&a.fillColor||c.fillColor;f&&(a=c.states[f].fillColor,e=c.states[f].lineColor,
h=c.states[f].lineWidth);return{fill:a||d,stroke:e||d,"stroke-width":h||c.lineWidth||0}},translate:n.translate,getPlotBox:n.getPlotBox,drawPoints:function(){var a=this.points,f=this.chart,h=f.renderer,d=f.inverted,l=this.options,k=l.y,y,n=this.yAxis,u={},b=[];for(y=a.length;y--;){var g=a[y];var z=(d?g.plotY:g.plotX)>this.xAxis.len;var A=g.plotX;var p=g.stackIndex;var q=g.options.shape||l.shape;var v=g.plotY;"undefined"!==typeof v&&(v=g.plotY+k-("undefined"!==typeof p&&p*l.stackDistance));g.anchorX=
p?void 0:g.plotX;var K=p?void 0:g.plotY;var x="flag"!==q;p=g.graphic;"undefined"!==typeof v&&0<=A&&!z?(p||(p=g.graphic=h.label("",null,null,q,null,null,l.useHTML),f.styledMode||p.attr(this.pointAttribs(g)).css(w(l.style,g.style)),p.attr({align:x?"center":"left",width:l.width,height:l.height,"text-align":l.textAlign}).addClass("highcharts-point").add(this.markerGroup),g.graphic.div&&(g.graphic.div.point=g),f.styledMode||p.shadow(l.shadow),p.isNew=!0),0<A&&(A-=p.strokeWidth()%2),q={y:v,anchorY:K},l.allowOverlapX&&
(q.x=A,q.anchorX=g.anchorX),p.attr({text:g.options.title||l.title||"A"})[p.isNew?"attr":"animate"](q),l.allowOverlapX||(u[g.plotX]?u[g.plotX].size=Math.max(u[g.plotX].size,p.width):u[g.plotX]={align:x?.5:0,size:p.width,target:A,anchorX:A}),g.tooltipPos=[A,v+n.pos-f.plotTop]):p&&(g.graphic=p.destroy())}l.allowOverlapX||(E(u,function(a){a.plotX=a.anchorX;b.push(a)}),e.distribute(b,d?n.len:this.xAxis.len,100),a.forEach(function(a){var b=a.graphic&&u[a.plotX];b&&(a.graphic[a.graphic.isNew?"attr":"animate"]({x:b.pos+
b.align*b.size,anchorX:a.anchorX}),B(b.pos)?a.graphic.isNew=!1:(a.graphic.attr({x:-9999,anchorX:-9999}),a.graphic.isNew=!0))}));l.useHTML&&t(this.markerGroup,"on",function(a){return e.SVGElement.prototype.on.apply(a.apply(this,[].slice.call(arguments,1)),[].slice.call(arguments,1))})},drawTracker:function(){var a=this.points;q.drawTrackerPoint.apply(this);a.forEach(function(c){var f=c.graphic;f&&x(f.element,"mouseover",function(){0<c.stackIndex&&!c.raised&&(c._y=f.y,f.attr({y:c._y-8}),c.raised=!0);
a.forEach(function(a){a!==c&&a.raised&&a.graphic&&(a.graphic.attr({y:a._y}),a.raised=!1)})})})},animate:function(a){a?this.setClip():this.animate=null},setClip:function(){v.prototype.setClip.apply(this,arguments);!1!==this.options.clip&&this.sharedClipKey&&this.markerGroup.clip(this.chart[this.sharedClipKey])},buildKDTree:h,invertGroups:h},{isValid:function(){return D(this.y)||"undefined"===typeof this.y}});a.flag=function(c,f,e,d,l){var h=l&&l.anchorX||c;l=l&&l.anchorY||f;return a.circle(h-1,l-1,
2,2).concat(["M",h,l,"L",c,f+d,c,f,c+e,f,c+e,f+d,c,f+d,"Z"])};C("circle");C("square");f===k&&["circlepin","flag","squarepin"].forEach(function(c){k.prototype.symbols[c]=a[c]});""});H(n,"parts/RangeSelector.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,h){function n(a){this.init(a)}var C=h.defined,B=h.destroyObjectProperties,D=h.discardElement,E=h.extend,t=h.isNumber,x=h.objectEach,w=h.pick,f=h.pInt,v=h.splat,p=e.addEvent,q=e.Axis;h=e.Chart;var k=e.css,a=e.createElement,c=e.defaultOptions,
m=e.fireEvent,G=e.merge;E(c,{rangeSelector:{verticalAlign:"top",buttonTheme:{width:28,height:18,padding:2,zIndex:7},floating:!1,x:0,y:0,height:void 0,inputPosition:{align:"right",x:0,y:0},buttonPosition:{align:"left",x:0,y:0},labelStyle:{color:"#666666"}}});c.lang=G(c.lang,{rangeSelectorZoom:"Zoom",rangeSelectorFrom:"From",rangeSelectorTo:"To"});n.prototype={clickButton:function(a,c){var d=this.chart,f=this.buttonOptions[a],e=d.xAxis[0],l=d.scroller&&d.scroller.getUnionExtremes()||e||{},b=l.dataMin,
g=l.dataMax,h=e&&Math.round(Math.min(e.max,w(g,e.max))),k=f.type;l=f._range;var m,n=f.dataGrouping;if(null!==b&&null!==g){d.fixedRange=l;n&&(this.forcedDataGrouping=!0,q.prototype.setDataGrouping.call(e||{chart:this.chart},n,!1),this.frozenStates=f.preserveDataGrouping);if("month"===k||"year"===k)if(e){k={range:f,max:h,chart:d,dataMin:b,dataMax:g};var x=e.minFromRange.call(k);t(k.newMax)&&(h=k.newMax)}else l=f;else if(l)x=Math.max(h-l,b),h=Math.min(x+l,g);else if("ytd"===k)if(e)"undefined"===typeof g&&
(b=Number.MAX_VALUE,g=Number.MIN_VALUE,d.series.forEach(function(a){a=a.xData;b=Math.min(a[0],b);g=Math.max(a[a.length-1],g)}),c=!1),h=this.getYTDExtremes(g,b,d.time.useUTC),x=m=h.min,h=h.max;else{this.deferredYTDClick=a;return}else"all"===k&&e&&(x=b,h=g);x+=f._offsetMin;h+=f._offsetMax;this.setSelected(a);if(e)e.setExtremes(x,h,w(c,1),null,{trigger:"rangeSelectorButton",rangeSelectorButton:f});else{var K=v(d.options.xAxis)[0];var V=K.range;K.range=l;var B=K.min;K.min=m;p(d,"load",function(){K.range=
V;K.min=B})}}},setSelected:function(a){this.selected=this.options.selected=a},defaultButtons:[{type:"month",count:1,text:"1m"},{type:"month",count:3,text:"3m"},{type:"month",count:6,text:"6m"},{type:"ytd",text:"YTD"},{type:"year",count:1,text:"1y"},{type:"all",text:"All"}],init:function(a){var d=this,c=a.options.rangeSelector,f=c.buttons||[].concat(d.defaultButtons),e=c.selected,h=function(){var a=d.minInput,g=d.maxInput;a&&a.blur&&m(a,"blur");g&&g.blur&&m(g,"blur")};d.chart=a;d.options=c;d.buttons=
[];d.buttonOptions=f;this.unMouseDown=p(a.container,"mousedown",h);this.unResize=p(a,"resize",h);f.forEach(d.computeButtonRange);"undefined"!==typeof e&&f[e]&&this.clickButton(e,!1);p(a,"load",function(){a.xAxis&&a.xAxis[0]&&p(a.xAxis[0],"setExtremes",function(b){this.max-this.min!==a.fixedRange&&"rangeSelectorButton"!==b.trigger&&"updatedData"!==b.trigger&&d.forcedDataGrouping&&!d.frozenStates&&this.setDataGrouping(!1,!1)})})},updateButtonStates:function(){var a=this,c=this.chart,f=c.xAxis[0],e=
Math.round(f.max-f.min),h=!f.hasVisibleSeries,k=c.scroller&&c.scroller.getUnionExtremes()||f,b=k.dataMin,g=k.dataMax;c=a.getYTDExtremes(g,b,c.time.useUTC);var m=c.min,p=c.max,n=a.selected,q=t(n),w=a.options.allButtonsEnabled,v=a.buttons;a.buttonOptions.forEach(function(d,c){var l=d._range,k=d.type,u=d.count||1,r=v[c],y=0,A=d._offsetMax-d._offsetMin;d=c===n;var z=l>g-b,t=l<f.minRange,x=!1,F=!1;l=l===e;("month"===k||"year"===k)&&e+36E5>=864E5*{month:28,year:365}[k]*u-A&&e-36E5<=864E5*{month:31,year:366}[k]*
u+A?l=!0:"ytd"===k?(l=p-m+A===e,x=!d):"all"===k&&(l=f.max-f.min>=g-b,F=!d&&q&&l);k=!w&&(z||t||F||h);u=d&&l||l&&!q&&!x||d&&a.frozenStates;k?y=3:u&&(q=!0,y=2);r.state!==y&&(r.setState(y),0===y&&n===c&&a.setSelected(null))})},computeButtonRange:function(a){var d=a.type,c=a.count||1,f={millisecond:1,second:1E3,minute:6E4,hour:36E5,day:864E5,week:6048E5};if(f[d])a._range=f[d]*c;else if("month"===d||"year"===d)a._range=864E5*{month:30,year:365}[d]*c;a._offsetMin=w(a.offsetMin,0);a._offsetMax=w(a.offsetMax,
0);a._range+=a._offsetMax-a._offsetMin},setInputValue:function(a,c){var d=this.chart.options.rangeSelector,f=this.chart.time,e=this[a+"Input"];C(c)&&(e.previousValue=e.HCTime,e.HCTime=c);e.value=f.dateFormat(d.inputEditDateFormat||"%Y-%m-%d",e.HCTime);this[a+"DateBox"].attr({text:f.dateFormat(d.inputDateFormat||"%b %e, %Y",e.HCTime)})},showInput:function(a){var d=this.inputGroup,c=this[a+"DateBox"];k(this[a+"Input"],{left:d.translateX+c.x+"px",top:d.translateY+"px",width:c.width-2+"px",height:c.height-
2+"px",border:"2px solid silver"})},hideInput:function(a){k(this[a+"Input"],{border:0,width:"1px",height:"1px"});this.setInputValue(a)},drawInput:function(d){function l(){var a=A.value,d=(b.inputDateParser||Date.parse)(a),g=m.xAxis[0],c=m.scroller&&m.scroller.xAxis?m.scroller.xAxis:g,e=c.dataMin;c=c.dataMax;d!==A.previousValue&&(A.previousValue=d,t(d)||(d=a.split("-"),d=Date.UTC(f(d[0]),f(d[1])-1,f(d[2]))),t(d)&&(m.time.useUTC||(d+=6E4*(new Date).getTimezoneOffset()),n?d>h.maxInput.HCTime?d=void 0:
d<e&&(d=e):d<h.minInput.HCTime?d=void 0:d>c&&(d=c),"undefined"!==typeof d&&g.setExtremes(n?d:g.min,n?g.max:d,void 0,void 0,{trigger:"rangeSelectorInput"})))}var h=this,m=h.chart,p=m.renderer.style||{},u=m.renderer,b=m.options.rangeSelector,g=h.div,n="min"===d,A,q,w=this.inputGroup;this[d+"Label"]=q=u.label(c.lang[n?"rangeSelectorFrom":"rangeSelectorTo"],this.inputGroup.offset).addClass("highcharts-range-label").attr({padding:2}).add(w);w.offset+=q.width+5;this[d+"DateBox"]=u=u.label("",w.offset).addClass("highcharts-range-input").attr({padding:2,
width:b.inputBoxWidth||90,height:b.inputBoxHeight||17,"text-align":"center"}).on("click",function(){h.showInput(d);h[d+"Input"].focus()});m.styledMode||u.attr({stroke:b.inputBoxBorderColor||"#cccccc","stroke-width":1});u.add(w);w.offset+=u.width+(n?10:0);this[d+"Input"]=A=a("input",{name:d,className:"highcharts-range-selector",type:"text"},{top:m.plotTop+"px"},g);m.styledMode||(q.css(G(p,b.labelStyle)),u.css(G({color:"#333333"},p,b.inputStyle)),k(A,E({position:"absolute",border:0,width:"1px",height:"1px",
padding:0,textAlign:"center",fontSize:p.fontSize,fontFamily:p.fontFamily,top:"-9999em"},b.inputStyle)));A.onfocus=function(){h.showInput(d)};A.onblur=function(){A===e.doc.activeElement&&l();h.hideInput(d);A.blur()};A.onchange=l;A.onkeypress=function(a){13===a.keyCode&&l()}},getPosition:function(){var a=this.chart,c=a.options.rangeSelector;a="top"===c.verticalAlign?a.plotTop-a.axisOffset[0]:0;return{buttonTop:a+c.buttonPosition.y,inputTop:a+c.inputPosition.y-10}},getYTDExtremes:function(a,c,f){var d=
this.chart.time,e=new d.Date(a),h=d.get("FullYear",e);f=f?d.Date.UTC(h,0,1):+new d.Date(h,0,1);c=Math.max(c||0,f);e=e.getTime();return{max:Math.min(a||e,e),min:c}},render:function(d,f){var e=this,h=e.chart,l=h.renderer,k=h.container,b=h.options,g=b.exporting&&!1!==b.exporting.enabled&&b.navigation&&b.navigation.buttonOptions,m=c.lang,p=e.div,n=b.rangeSelector,q=w(b.chart.style&&b.chart.style.zIndex,0)+1;b=n.floating;var t=e.buttons;p=e.inputGroup;var v=n.buttonTheme,x=n.buttonPosition,B=n.inputPosition,
D=n.inputEnabled,C=v&&v.states,E=h.plotLeft,I=e.buttonGroup;var G=e.rendered;var H=e.options.verticalAlign,P=h.legend,Q=P&&P.options,R=x.y,O=B.y,S=G||!1,T=S?"animate":"attr",N=0,L=0,M;if(!1!==n.enabled){G||(e.group=G=l.g("range-selector-group").attr({zIndex:7}).add(),e.buttonGroup=I=l.g("range-selector-buttons").add(G),e.zoomText=l.text(m.rangeSelectorZoom,0,15).add(I),h.styledMode||(e.zoomText.css(n.labelStyle),v["stroke-width"]=w(v["stroke-width"],0)),e.buttonOptions.forEach(function(a,b){t[b]=
l.button(a.text,0,0,function(d){var g=a.events&&a.events.click,c;g&&(c=g.call(a,d));!1!==c&&e.clickButton(b);e.isActive=!0},v,C&&C.hover,C&&C.select,C&&C.disabled).attr({"text-align":"center"}).add(I)}),!1!==D&&(e.div=p=a("div",null,{position:"relative",height:0,zIndex:q}),k.parentNode.insertBefore(p,k),e.inputGroup=p=l.g("input-group").add(G),p.offset=0,e.drawInput("min"),e.drawInput("max")));e.zoomText[T]({x:w(E+x.x,E)});var U=w(E+x.x,E)+e.zoomText.getBBox().width+5;e.buttonOptions.forEach(function(a,
b){t[b][T]({x:U});U+=t[b].width+w(n.buttonSpacing,5)});E=h.plotLeft-h.spacing[3];e.updateButtonStates();g&&this.titleCollision(h)&&"top"===H&&"right"===x.align&&x.y+I.getBBox().height-12<(g.y||0)+g.height&&(N=-40);"left"===x.align?M=x.x-h.spacing[3]:"right"===x.align&&(M=x.x+N-h.spacing[1]);I.align({y:x.y,width:I.getBBox().width,align:x.align,x:M},!0,h.spacingBox);e.group.placed=S;e.buttonGroup.placed=S;!1!==D&&(N=g&&this.titleCollision(h)&&"top"===H&&"right"===B.align&&B.y-p.getBBox().height-12<
(g.y||0)+g.height+h.spacing[0]?-40:0,"left"===B.align?M=E:"right"===B.align&&(M=-Math.max(h.axisOffset[1],-N)),p.align({y:B.y,width:p.getBBox().width,align:B.align,x:B.x+M-2},!0,h.spacingBox),k=p.alignAttr.translateX+p.alignOptions.x-N+p.getBBox().x+2,g=p.alignOptions.width,m=I.alignAttr.translateX+I.getBBox().x,M=I.getBBox().width+20,(B.align===x.align||m+M>k&&k+g>m&&R<O+p.getBBox().height)&&p.attr({translateX:p.alignAttr.translateX+(h.axisOffset[1]>=-N?0:-N),translateY:p.alignAttr.translateY+I.getBBox().height+
10}),e.setInputValue("min",d),e.setInputValue("max",f),e.inputGroup.placed=S);e.group.align({verticalAlign:H},!0,h.spacingBox);d=e.group.getBBox().height+20;f=e.group.alignAttr.translateY;"bottom"===H&&(P=Q&&"bottom"===Q.verticalAlign&&Q.enabled&&!Q.floating?P.legendHeight+w(Q.margin,10):0,d=d+P-20,L=f-d-(b?0:n.y)-(h.titleOffset?h.titleOffset[2]:0)-10);if("top"===H)b&&(L=0),h.titleOffset&&h.titleOffset[0]&&(L=h.titleOffset[0]),L+=h.margin[0]-h.spacing[0]||0;else if("middle"===H)if(O===R)L=0>O?f+void 0:
f;else if(O||R)L=0>O||0>R?L-Math.min(O,R):f-d+NaN;e.group.translate(n.x,n.y+Math.floor(L));!1!==D&&(e.minInput.style.marginTop=e.group.translateY+"px",e.maxInput.style.marginTop=e.group.translateY+"px");e.rendered=!0}},getHeight:function(){var a=this.options,c=this.group,e=a.y,f=a.buttonPosition.y,h=a.inputPosition.y;if(a.height)return a.height;a=c?c.getBBox(!0).height+13+e:0;c=Math.min(h,f);if(0>h&&0>f||0<h&&0<f)a+=Math.abs(c);return a},titleCollision:function(a){return!(a.options.title.text||a.options.subtitle.text)},
update:function(a){var d=this.chart;G(!0,d.options.rangeSelector,a);this.destroy();this.init(d);d.rangeSelector.render()},destroy:function(){var a=this,c=a.minInput,e=a.maxInput;a.unMouseDown();a.unResize();B(a.buttons);c&&(c.onfocus=c.onblur=c.onchange=null);e&&(e.onfocus=e.onblur=e.onchange=null);x(a,function(d,c){d&&"chart"!==c&&(d.destroy?d.destroy():d.nodeType&&D(this[c]));d!==n.prototype[c]&&(a[c]=null)},this)}};q.prototype.minFromRange=function(){var a=this.range,c={month:"Month",year:"FullYear"}[a.type],
e=this.max,f=this.chart.time,h=function(a,b){var d=new f.Date(a),g=f.get(c,d);f.set(c,d,g+b);g===f.get(c,d)&&f.set("Date",d,0);return d.getTime()-a};if(t(a)){var k=e-a;var b=a}else k=e+h(e,-a.count),this.chart&&(this.chart.fixedRange=e-k);var g=w(this.dataMin,Number.MIN_VALUE);t(k)||(k=g);k<=g&&(k=g,"undefined"===typeof b&&(b=h(k,a.count)),this.newMax=Math.min(k+b,this.dataMax));t(e)||(k=void 0);return k};e.RangeSelector||(p(h,"afterGetContainer",function(){this.options.rangeSelector.enabled&&(this.rangeSelector=
new n(this))}),p(h,"beforeRender",function(){var a=this.axes,c=this.rangeSelector;c&&(t(c.deferredYTDClick)&&(c.clickButton(c.deferredYTDClick),delete c.deferredYTDClick),a.forEach(function(a){a.updateNames();a.setScale()}),this.getAxisMargins(),c.render(),a=c.options.verticalAlign,c.options.floating||("bottom"===a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0)))}),p(h,"update",function(a){var c=a.options.rangeSelector;a=this.rangeSelector;var d=this.extraBottomMargin,e=this.extraTopMargin;
c&&c.enabled&&!C(a)&&(this.options.rangeSelector.enabled=!0,this.rangeSelector=new n(this));this.extraTopMargin=this.extraBottomMargin=!1;a&&(a.render(),c=c&&c.verticalAlign||a.options&&a.options.verticalAlign,a.options.floating||("bottom"===c?this.extraBottomMargin=!0:"middle"!==c&&(this.extraTopMargin=!0)),this.extraBottomMargin!==d||this.extraTopMargin!==e)&&(this.isDirtyBox=!0)}),p(h,"render",function(){var a=this.rangeSelector;a&&!a.options.floating&&(a.render(),a=a.options.verticalAlign,"bottom"===
a?this.extraBottomMargin=!0:"middle"!==a&&(this.extraTopMargin=!0))}),p(h,"getMargins",function(){var a=this.rangeSelector;a&&(a=a.getHeight(),this.extraTopMargin&&(this.plotTop+=a),this.extraBottomMargin&&(this.marginBottom+=a))}),h.prototype.callbacks.push(function(a){function c(){e=a.xAxis[0].getExtremes();t(e.min)&&d.render(e.min,e.max)}var e,d=a.rangeSelector;if(d){var f=p(a.xAxis[0],"afterSetExtremes",function(a){d.render(a.min,a.max)});var h=p(a,"redraw",c);c()}p(a,"destroy",function(){d&&
(h(),f())})}),e.RangeSelector=n)});H(n,"parts/StockChart.js",[n["parts/Globals.js"],n["parts/Utilities.js"]],function(e,h){var n=h.arrayMax,C=h.arrayMin,B=h.clamp,D=h.defined,E=h.extend,t=h.isNumber,x=h.isString,w=h.pick,f=h.splat;h=e.addEvent;var v=e.Axis,p=e.Chart,q=e.format,k=e.merge,a=e.Point,c=e.Renderer,m=e.Series,G=e.SVGRenderer,d=e.VMLRenderer,l=m.prototype,r=l.init,y=l.processData,F=a.prototype.tooltipFormatter;e.StockChart=e.stockChart=function(a,b,c){var g=x(a)||a.nodeName,d=arguments[g?
1:0],h=d,l=d.series,m=e.getOptions(),u,n=d.chart&&d.chart.panning,q=w(d.navigator&&d.navigator.enabled,m.navigator.enabled,!0),r=n&&/y/.test(n.type),t={startOnTick:!1,endOnTick:!1};d.xAxis=f(d.xAxis||{}).map(function(a,b){return k({minPadding:0,maxPadding:0,overscroll:0,ordinal:!0,title:{text:null},labels:{overflow:"justify"},showLastLabel:!0},m.xAxis,m.xAxis&&m.xAxis[b],a,{type:"datetime",categories:null},q?t:null)});d.yAxis=f(d.yAxis||{}).map(function(a,b){u=w(a.opposite,!0);return k({labels:{y:-2},
opposite:u,showLastLabel:!(!a.categories&&"category"!==a.type),title:{text:null}},m.yAxis,m.yAxis&&m.yAxis[b],a,r?t:null)});d.series=null;d=k({chart:{panning:{enabled:!0,type:"x"},pinchType:"x"},navigator:{enabled:q},scrollbar:{enabled:w(m.scrollbar.enabled,!0)},rangeSelector:{enabled:w(m.rangeSelector.enabled,!0)},title:{text:null},tooltip:{split:w(m.tooltip.split,!0),crosshairs:!0},legend:{enabled:!1}},d,{isStock:!0});d.series=h.series=l;return g?new p(a,d,c):new p(d,b)};h(m,"setOptions",function(a){function b(a){return e.seriesTypes[a]&&
c instanceof e.seriesTypes[a]}var c=this,d;this.chart.options.isStock&&(b("column")||b("columnrange")?d={borderWidth:0,shadow:!1}:!b("line")||b("scatter")||b("sma")||(d={marker:{enabled:!1,radius:2}}),d&&(a.plotOptions[this.type]=k(a.plotOptions[this.type],d)))});h(v,"autoLabelAlign",function(a){var b=this.chart,c=this.options;b=b._labelPanes=b._labelPanes||{};var d=this.options.labels;this.chart.options.isStock&&"yAxis"===this.coll&&(c=c.top+","+c.height,!b[c]&&d.enabled&&(15===d.x&&(d.x=0),"undefined"===
typeof d.align&&(d.align="right"),b[c]=this,a.align="right",a.preventDefault()))});h(v,"destroy",function(){var a=this.chart,b=this.options&&this.options.top+","+this.options.height;b&&a._labelPanes&&a._labelPanes[b]===this&&delete a._labelPanes[b]});h(v,"getPlotLinePath",function(a){function b(a){var b="xAxis"===a?"yAxis":"xAxis";a=c.options[b];return t(a)?[f[b][a]]:x(a)?[f.get(a)]:d.map(function(a){return a[b]})}var c=this,d=this.isLinked&&!this.series?this.linkedParent.series:this.series,f=c.chart,
h=f.renderer,k=c.left,l=c.top,m,u,p,n,q=[],r=[],v=a.translatedValue,y=a.value,C=a.force;if(f.options.isStock&&!1!==a.acrossPanes&&"xAxis"===c.coll||"yAxis"===c.coll){a.preventDefault();r=b(c.coll);var E=c.isXAxis?f.yAxis:f.xAxis;E.forEach(function(a){if(D(a.options.id)?-1===a.options.id.indexOf("navigator"):1){var b=a.isXAxis?"yAxis":"xAxis";b=D(a.options[b])?f[b][a.options[b]]:f[b][0];c===b&&r.push(a)}});var F=r.length?[]:[c.isXAxis?f.yAxis[0]:f.xAxis[0]];r.forEach(function(a){-1!==F.indexOf(a)||
e.find(F,function(b){return b.pos===a.pos&&b.len===a.len})||F.push(a)});var G=w(v,c.translate(y,null,null,a.old));t(G)&&(c.horiz?F.forEach(function(a){var b;u=a.pos;n=u+a.len;m=p=Math.round(G+c.transB);"pass"!==C&&(m<k||m>k+c.width)&&(C?m=p=B(m,k,k+c.width):b=!0);b||q.push("M",m,u,"L",p,n)}):F.forEach(function(a){var b;m=a.pos;p=m+a.len;u=n=Math.round(l+c.height-G);"pass"!==C&&(u<l||u>l+c.height)&&(C?u=n=B(u,l,l+c.height):b=!0);b||q.push("M",m,u,"L",p,n)}));a.path=0<q.length?h.crispPolyLine(q,a.lineWidth||
1):null}});G.prototype.crispPolyLine=function(a,b){var c;for(c=0;c<a.length;c+=6)a[c+1]===a[c+4]&&(a[c+1]=a[c+4]=Math.round(a[c+1])-b%2/2),a[c+2]===a[c+5]&&(a[c+2]=a[c+5]=Math.round(a[c+2])+b%2/2);return a};c===d&&(d.prototype.crispPolyLine=G.prototype.crispPolyLine);h(v,"afterHideCrosshair",function(){this.crossLabel&&(this.crossLabel=this.crossLabel.hide())});h(v,"afterDrawCrosshair",function(a){var b,c;if(D(this.crosshair.label)&&this.crosshair.label.enabled&&this.cross){var d=this.chart,e=this.options.crosshair.label,
f=this.horiz,h=this.opposite,k=this.left,l=this.top,m=this.crossLabel,p=e.format,n="",u="inside"===this.options.tickPosition,r=!1!==this.crosshair.snap,t=0,v=a.e||this.cross&&this.cross.e,x=a.point;var y=this.lin2log;if(this.isLog){a=y(this.min);var B=y(this.max)}else a=this.min,B=this.max;y=f?"center":h?"right"===this.labelAlign?"right":"left":"left"===this.labelAlign?"left":"center";m||(m=this.crossLabel=d.renderer.label(null,null,null,e.shape||"callout").addClass("highcharts-crosshair-label"+(this.series[0]&&
" highcharts-color-"+this.series[0].colorIndex)).attr({align:e.align||y,padding:w(e.padding,8),r:w(e.borderRadius,3),zIndex:2}).add(this.labelGroup),d.styledMode||m.attr({fill:e.backgroundColor||this.series[0]&&this.series[0].color||"#666666",stroke:e.borderColor||"","stroke-width":e.borderWidth||0}).css(E({color:"#ffffff",fontWeight:"normal",fontSize:"11px",textAlign:"center"},e.style)));f?(y=r?x.plotX+k:v.chartX,l+=h?0:this.height):(y=h?this.width+k:0,l=r?x.plotY+l:v.chartY);p||e.formatter||(this.isDatetimeAxis&&
(n="%b %d, %Y"),p="{value"+(n?":"+n:"")+"}");n=r?x[this.isXAxis?"x":"y"]:this.toValue(f?v.chartX:v.chartY);m.attr({text:p?q(p,{value:n},d):e.formatter.call(this,n),x:y,y:l,visibility:n<a||n>B?"hidden":"visible"});e=m.getBBox();if(f){if(u&&!h||!u&&h)l=m.y-e.height}else l=m.y-e.height/2;f?(b=k-e.x,c=k+this.width-e.x):(b="left"===this.labelAlign?k:0,c="right"===this.labelAlign?k+this.width:d.chartWidth);m.translateX<b&&(t=b-m.translateX);m.translateX+e.width>=c&&(t=-(m.translateX+e.width-c));m.attr({x:y+
t,y:l,anchorX:f?y:this.opposite?0:d.chartWidth,anchorY:f?this.opposite?d.chartHeight:0:l+e.height/2})}});l.init=function(){r.apply(this,arguments);this.setCompare(this.options.compare)};l.setCompare=function(a){this.modifyValue="value"===a||"percent"===a?function(b,c){var d=this.compareValue;return"undefined"!==typeof b&&"undefined"!==typeof d?(b="value"===a?b-d:b/d*100-(100===this.options.compareBase?0:100),c&&(c.change=b),b):0}:null;this.userOptions.compare=a;this.chart.hasRendered&&(this.isDirty=
!0)};l.processData=function(a){var b,c=-1,d=!0===this.options.compareStart?0:1;y.apply(this,arguments);if(this.xAxis&&this.processedYData){var e=this.processedXData;var f=this.processedYData;var h=f.length;this.pointArrayMap&&(c=this.pointArrayMap.indexOf(this.options.pointValKey||this.pointValKey||"y"));for(b=0;b<h-d;b++){var k=f[b]&&-1<c?f[b][c]:f[b];if(t(k)&&e[b+d]>=this.xAxis.min&&0!==k){this.compareValue=k;break}}}};h(m,"afterGetExtremes",function(){if(this.modifyValue){var a=[this.modifyValue(this.dataMin),
this.modifyValue(this.dataMax)];this.dataMin=C(a);this.dataMax=n(a)}});v.prototype.setCompare=function(a,b){this.isXAxis||(this.series.forEach(function(b){b.setCompare(a)}),w(b,!0)&&this.chart.redraw())};a.prototype.tooltipFormatter=function(a){var b=this.series.chart.numberFormatter;a=a.replace("{point.change}",(0<this.change?"+":"")+b(this.change,w(this.series.tooltipOptions.changeDecimals,2)));return F.apply(this,[a])};h(m,"render",function(){var a=this.chart;if(!(a.is3d&&a.is3d()||a.polar)&&this.xAxis&&
!this.xAxis.isRadial){var b=this.yAxis.len;if(this.xAxis.axisLine){var c=a.plotTop+a.plotHeight-this.yAxis.pos-this.yAxis.len,d=Math.floor(this.xAxis.axisLine.strokeWidth()/2);0<=c&&(b-=Math.max(d-c,0))}!this.clipBox&&this.animate?(this.clipBox=k(a.clipBox),this.clipBox.width=this.xAxis.len,this.clipBox.height=b):a[this.sharedClipKey]&&(a[this.sharedClipKey].animate({width:this.xAxis.len,height:b}),a[this.sharedClipKey+"m"]&&a[this.sharedClipKey+"m"].animate({width:this.xAxis.len}))}});h(p,"update",
function(a){a=a.options;"scrollbar"in a&&this.navigator&&(k(!0,this.options.scrollbar,a.scrollbar),this.navigator.update({},!1),delete a.scrollbar)});h(v,"afterSetScale",function(){var a=this,b=a.chart.options.chart&&a.chart.options.chart.panning;if(b&&("y"===b.type||"xy"===b.type)&&!a.isXAxis&&!D(a.panningState)){var c=Number.MAX_VALUE,d=Number.MIN_VALUE;a.series.forEach(function(b){c=Math.min(e.arrayMin(b.yData),c)-(a.min&&a.dataMin?a.dataMin-a.min:0);d=Math.max(e.arrayMax(b.yData),d)+(a.max&&a.dataMax?
a.max-a.dataMax:0)});a.panningState={startMin:c,startMax:d}}})});H(n,"masters/modules/stock.src.js",[],function(){})});
//# sourceMappingURL=stock.js.map