<!DOCTYPE html>
<html lang="en">
<head>
    <title id='Description'>This demo shows how to integrate jqxTabs with other widgets.
    </title>
    <link rel="stylesheet" href="jqwidgets/styles/jqx.base.css" type="text/css" />
    <script type="text/javascript" src="scripts/jquery-1.11.1.min.js"></script>
    <script type="text/javascript" src="scripts/demos.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxcore.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxtabs.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxcheckbox.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxmenu.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxgrid.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxgrid.selection.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxbuttons.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxscrollbar.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxlistbox.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxdropdownlist.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxdata.js"></script>
    <script type="text/javascript" src="jqwidgets/jqxchart.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            var initGrid = function () {
                var source =
               {
                   datatype: "csv",
                   datafields: [
                        { name: 'Date' },
                        { name: 'S&P 500' },
                        { name: 'NASDAQ' }
                    ],
                   url: 'nasdaq_vs_sp500.txt'
               };

                var dataAdapter = new $.jqx.dataAdapter(source, { async: false, loadError: function (xhr, status, error) { alert('Error loading "' + source.url + '" : ' + error); } });

                $("#jqxGrid").jqxGrid(
                {
                    width: '100%',
                    height: '84%',
                    source: dataAdapter,
                    columns: [
                        { text: 'Date', datafield: 'Date', cellsformat: 'd', width: 250 },
                        { text: 'S&P 500', datafield: 'S&P 500', width: 150 },
                        { text: 'NASDAQ', datafield: 'NASDAQ' }
                    ]
                });
            }

            var initChart = function () {
                // prepare the data
                var source =
               {
                   datatype: "csv",
                   datafields: [
                        { name: 'Date' },
                        { name: 'S&P 500' },
                        { name: 'NASDAQ' }
                    ],
                   url: 'nasdaq_vs_sp500.txt'
               };

                var dataAdapter = new $.jqx.dataAdapter(source, { async: false, autoBind: true, loadError: function (xhr, status, error) { alert('Error loading "' + source.url + '" : ' + error); } });
                var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

                // prepare jqxChart settings
                var settings = {
                    title: "U.S. Stock Market Index Performance (2011)",
                    description: "NASDAQ Composite compared to S&P 500",
                    enableAnimations: true,
                    showLegend: true,
                    padding: { left: 10, top: 5, right: 10, bottom: 5 },
                    titlePadding: { left: 90, top: 0, right: 0, bottom: 10 },
                    source: dataAdapter,
                    categoryAxis:
                    {
                        dataField: 'Date',
                        formatFunction: function (value) {
                            return months[value.getMonth()];
                        },
                        toolTipFormatFunction: function (value) {
                            return value.getDate() + '-' + months[value.getMonth()];
                        },
                        type: 'date',
                        baseUnit: 'month',
                        showTickMarks: true,
                        tickMarksInterval: 1,
                        tickMarksColor: '#888888',
                        unitInterval: 1,
                        showGridLines: true,
                        gridLinesInterval: 3,
                        gridLinesColor: '#888888',
                        valuesOnTicks: false
                    },
                    colorScheme: 'scheme04',
                    seriesGroups:
                    [
                        {
                            type: 'line',
                            valueAxis:
                            {
                                displayValueAxis: true,
                                description: 'Daily Closing Price',
                                axisSize: 'auto',
                                tickMarksColor: '#888888'
                            },
                            series: [
                                    { dataField: 'S&P 500', displayText: 'S&P 500' },
                                    { dataField: 'NASDAQ', displayText: 'NASDAQ' }
                                ]
                        }
                    ]
                };

                // setup the chart
                $('#jqxChart').jqxChart(settings);
            }

            // init widgets.
            var initWidgets = function (tab) {
                switch (tab) {
                    case 0:
                        initGrid();
                        break;
                    case 1:
                        initChart();
                        break;
                }
            }

            $('#jqxTabs').jqxTabs({ width: 600, height: 560,  initTabContent: initWidgets });
        });
    </script>
</head>
<body class='default'>
    <div id='jqxWidget'>
        <div id='jqxTabs'>
            <ul>
                <li style="margin-left: 30px;">
                    <div style="height: 20px; margin-top: 5px;">
                        <div style="float: left;">
                            <img width="16" height="16" src="../../images/catalogicon.png" />
                        </div>
                        <div style="margin-left: 4px; vertical-align: middle; text-align: center; float: left;">
                            US Indexes</div>
                    </div>
                </li>
                <li>
                    <div style="height: 20px; margin-top: 5px;">
                        <div style="float: left;">
                            <img width="16" height="16" src="../../images/pieicon.png" />
                        </div>
                        <div style="margin-left: 4px; vertical-align: middle; text-align: center; float: left;">
                            NASDAQ compared to S&P 500</div>
                    </div>
                </li>
            </ul>
            <div style="overflow: hidden;">
                <div id="jqxGrid">
                </div>
            </div>
            <div style="overflow: hidden;">
                <div id='jqxChart' style="width: 100%; height: 100%">
                </div>
            </div>
        </div>
    </div>
</body>
</html>
