<?php

require_once 'conexion.php';

class Comentarios extends Conexion {

    public $mysqli;
    public $data;
    private $tComentarios;

    public function __construct() {
        $this->mysqli = parent::conectar();
        $this->data = array();
    }
    
    //*****************************************************************
    // ULTIMO COMENTARIO
    //*****************************************************************
    public function ultimo_comentario($id) {

        $resultado = $this->mysqli->query("SELECT
            comentario_foro.id_comentario,
            comentario_foro.id_tema,
            comentario_foro.comentario,
            comentario_foro.fecha,
            comentario_foro.activo,
            foro_temas.titulo,
            foro_foro.id_foro,
            usuario.usu_nick as nick
            FROM
            comentario_foro
            INNER JOIN foro_temas ON foro_temas.id_tema = comentario_foro.id_tema
            INNER JOIN foro_foro ON foro_foro.id_foro = foro_temas.id_foro
            INNER JOIN usuario ON comentario_foro.id_usuario = usuario.usucod
            WHERE
            foro_foro.id_foro = $id
            ORDER BY
            comentario_foro.id_comentario DESC
            limit 1");

        while ( $fila = $resultado->fetch_assoc() ) {
            $this->data[] = $fila;
        }
        
        return $this->data;
    }

    //*****************************************************************
    // LISTA LOS COMENTARIOS
    //*****************************************************************
    public function comentarios($id) {

        $resultado = $this->mysqli->query("SELECT
            comentario_foro.id_comentario,
            comentario_foro.id_tema,
            comentario_foro.id_usuario,
            comentario_foro.comentario,
            comentario_foro.fecha,
            comentario_foro.activo,
            usuario.usu_nick as nick
            FROM
            comentario_foro
            INNER JOIN usuario ON comentario_foro.id_usuario = usuario.usucod 
            WHERE id_tema = $id");

        while ( $fila = $resultado->fetch_assoc() ) {
            $this->data[] = $fila;
        }
        
        return $this->data;
    }

    //*****************************************************************
    // TOTAL DE COMENTARIOS POR TEMA
    //*****************************************************************
    public function TotalComentarios($tema) {

        $resultado = $this->mysqli->query("select count(*) as total from comentario_foro where id_tema = '$tema'"); 

        if ($reg = $resultado->fetch_array()) {
            $this->tComentarios = $reg["total"];
        }

        return $this->tComentarios;
    }
    //*****************************************************************
    // TOTAL DE COMENTARIOS POR TEMA
    //*****************************************************************
    public function TotalComentariosUsuario($id) {

        $resultado = $this->mysqli->query("select count(*) as total from comentario_foro where id_usuario = '$id'"); 

        if ($reg = $resultado->fetch_array()) {
            $this->tComentarios = $reg["total"];
        }

        return $this->tComentarios;
    }
    //*****************************************************************
    // TOTAL DE COMENTARIOS POR FORO
    //*****************************************************************
    public function TotalComentariosForo($foro) {
        $resultado = $this->mysqli->query("SELECT count(*) as total
            FROM
            comentario_foro
            INNER JOIN foro_temas ON comentario_foro.id_tema = foro_temas.id_tema
            INNER JOIN foro_foro ON foro_temas.id_foro = foro_foro.id_foro
            WHERE
            foro_foro.id_foro = '$foro'"); 

        if ($reg = $resultado->fetch_array()) {
            $this->tComentarios = $reg["total"];
        }

        return $this->tComentarios;
    }
    //*****************************************************************
    // AGREGAR COMENTARIO
    //*****************************************************************
    public function add($id, $foro, $sub) {

        $comentario = $_POST['comentario'];
        $activo = 0;
        $usuario = $_SESSION['MM_Usercode'];
		$nombreusu=	$_SESSION['MM_Username'];

        $resultado = $this->mysqli->query("INSERT INTO comentario_foro(id_tema, id_usuario, comentario, fecha, activo) 
            VALUES($id, $usuario, '$comentario', now(), $activo)"); 
		// Eleccion de foro
		$resultado = $this->mysqli->query("select id_foro, foro from foro_foro WHERE id_foro=$foro");
     	$fila = $resultado->fetch_assoc();
		// Eleccion de tema
		$resultado1 = $this->mysqli->query("select id_tema, titulo from foro_temas WHERE id_tema=$id");
     	$fila1 = $resultado1->fetch_assoc();
        // envio de e-mail de creación		
		$para  = 'Jenny Paucay<jenny.paucay@gruposeguro.net>' . ', '; // atención a la coma
		$para .= 'Agencias <agenciasmx@marcimex.com.ec>'. ', ';
		$usuarios = $this->mysqli->query("SELECT CONCAT(nom_usuario,'<',email_usuario,'>') as correo FROM usuario_email where cod_estado=0");
		while( $datosusu = $usuarios->fetch_assoc() ){
            $para.= $datosusu['correo'];
			$para.= ',';
        }
        $para .= 'Subagencias <agenciassubmx@marcimex.com.ec>';
		// título
		$título = 'FORO MARCIMEX-SEGUROS MASIVOS-NUEVO COMENTARIO ';
		// mensaje
		$mensaje = '
		<html>
		<head>
		  <title>FORO MARCIMEX - NOTIFICACION DE NUEVO COMENTARIO</title>
		</head>
		<body>
		  <p>Revisar nuevo comentario creado dentro de nuestro sistema, dentro del foro <b><big>'.$fila['foro']. '</b></big> en el tema <b><big>'.$fila1['titulo'].'</b></big>. Para cualquier inquietud por favor crear un comentario dentro del mismo</p>
		  <br>
		  <br>
		  <p><b>POR FAVOR NO RESPONDER ESTE MENSAJE AUTOMATICO. GRACIAS</b></p>
		  <br>
		  <br>
		  <p><b>Atentamente</b></p>
		  <br>
		  <p><b><big>'.$nombreusu.'</p></big></b>
		</body>
		</html>
		';
		// Para enviar un correo HTML, debe establecerse la cabecera Content-type
		$cabeceras  = 'MIME-Version: 1.0' . "\r\n";
		$cabeceras .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
		// Cabeceras adicionales
		//$cabeceras .= 'To: psuarez@marcimex.com.ec , gtorres@marcimex.com.ec' . "\r\n";
		$cabeceras .= 'From: Sistemas<maritza.elizalde@gruposeguro.net>' . "\r\n";
		$cabeceras .= 'Cc: Paola Illescas <pillescas@marcimex.com.ec>' . "\r\n";
		//$cabeceras .= 'Bcc: Alfredo Vega <alfredo.vega@gruposeguro.net>' . "\r\n";
		// Enviarlo
		mail($para, $título, $mensaje, $cabeceras);
        
        if($sub == 0){
            echo "<script type='text/javascript'>window.location='tema.php?id=$id&foro=$foro';</script>";
        }else{
            echo "<script type='text/javascript'>window.location='tema.php?id=$id&foro=$foro&sub=$sub';</script>";
        }
    }

    //*****************************************************************
    // ULTIMO COMENTARIO
    //*****************************************************************
    public function ultmoComentario($id) {

        $resultado = $this->mysqli->query("SELECT
            comentario_foro.id_comentario,
            comentario_foro.id_tema,
            comentario_foro.comentario,
            comentario_foro.fecha,
            comentario_foro.activo,
            usuario.usu_nick as nick
            FROM
            comentario_foro
            INNER JOIN usuario ON comentario_foro.id_usuario = usuario.usucod
            where id_tema = $id
            ORDER BY
            comentario_foro.id_comentario DESC
            limit 1");

        while ( $fila = $resultado->fetch_assoc() ) {
            $this->data[] = $fila;
        }
        
        return $this->data;
    }

    //*****************************************************************
    // ELIMINA COMENTARIO
    //*****************************************************************
    public function del($id, $tema, $foro, $sub) {
        $resultado = $this->mysqli->query("DELETE FROM comentario_foro WHERE id_comentario = $id");

        if($sub == 0){
            header("Location: tema.php?id=$tema&foro=$foro");
        }else{
            header("Location: tema.php?id=$tema&foro=$foro&sub=$sub");
        }
        
    }
}
?>