/*
 * jQuery - Version dev
 *   http://jquery.com/
 *
 * To use, download this file to your server, save as jquery.js,
 * and add this HTML into the <head>...</head> of your web page:
 *   <script type="text/javascript" src="jquery.js"></script>
 *
 * Copyright (c) 2006 John Resig
 * Licensed under the MIT License:
 *   http://www.opensource.org/licenses/mit-license.php
 */
/* Built Sat Jun 17 22:46:19 2006 */
/*
 * jQuery (jquery.com)
 *
 * Copyright (c) 2006 John Resig (ejohn.org)
 * Licensed under the MIT License:
 *   http://www.opensource.org/licenses/mit-license.php
 *
 * $Date: 2006-06-17 21:29:53 -0400 (Sat, 17 Jun 2006) $
 * $Rev: 88 $
 */

/* For JSLint (jslint.com): */
/*extern ActiveXObject Prototype setTimeout setInterval clearInterval document window XMLHttpRequest navigator*/

function $(a,c) {
	var $a = a || $.context || document;
	var $c = c && c.$jquery && c.get(0) || c;

	// Since we're using Prototype's $ function,
	// be nice and have backwards compatability
	if ( typeof Prototype != "undefined" ) {
		if ( $a.constructor == String ) {
			var re = new RegExp( "[^a-zA-Z0-9_-]" );
			if ( !re.test($a) ) {
				$c = $c && $c.documentElement || document;
				if ( $c.getElementsByTagName($a).length === 0 ) {
					var obj = $c.getElementById($a);
					if ( obj ) { return obj; }
				}
			}
		} else if ( $a.constructor == Array ) {
			return $.map( $a, function(b){
				if ( b.constructor == String ) {
					return document.getElementById(b);
				}
				return b;
			});
		}
	}

	// Load Dynamic Function List
	var self = {
		cur: $.Select($a,$c),
		$jquery: "$Rev: 88 $",

		// The only two getters
		size: function() {return this.get().length;},
		get: function(i) {
			return typeof i == 'undefined' ? this.cur : this.cur[i];
		},

		each: function(f) {
			for ( var i = 0; i < this.size(); i++ )
				$.apply( this.get(i), f, [i] );
			return this;
		},
		set: function(a,b) {
			return this.each(function(){
				if ( typeof b == 'undefined' )
					for ( var j in a )
						$.attr(this,j,a[j]);
				else
					$.attr(this,a,b);
			});
		},
		html: function(h) {
			return typeof h == 'undefined' && this.size() ?
				this.get(0).innerHTML : this.set( "innerHTML", h );
		},
		val: function(h) {
			return typeof h == 'undefined' && this.size() ?
				this.get(0).value : this.set( "value", h );
		},

		css: function(a,b) {
			return  a.constructor != String || b ?
				this.each(function(){
					if ( !b )
						for ( var j in a )
							$.attr(this.style,j,a[j]);
					else
						$.attr(this.style,a,b);
				}) : $.css( this.get(0), a );
		},
		toggle: function() {
			return this.each(function(){
				var d = $.getCSS(this,"display");
				if ( d == "none" || d === '' )
					$(this).show();
				else
					$(this).hide();
			});
		},
		show: function(a) {
			return this.each(function(){
				this.style.display = this.$$oldblock ? this.$$oldblock : '';
				if ( $.getCSS(this,"display") == "none" )
					this.style.display = 'block';
			});
		},
		hide: function(a) {
			return this.each(function(){
				this.$$oldblock = $.getCSS(this,"display");
				if ( this.$$oldblock == "none" )
					this.$$oldblock = 'block';
				this.style.display = 'none';
			});
		},
		addClass: function(c) {
			return this.each(function(){
				if ($.hasWord(this,c)) return;
				this.className += ( this.className.length > 0 ? " " : "" ) + c;
			});
		},
		removeClass: function(c) {
			return this.each(function(){
				this.className = !c ? '' :
					this.className.replace(
						new RegExp('(^|\\s*\\b[^-])'+c+'($|\\b(?=[^-]))', 'g'), '');
			});
		},
		// TODO: Optomize
		toggleClass: function(c) {
			return this.each(function(){
				if ($.hasWord(this,c))
					this.className =
						this.className.replace(
							new RegExp('(\\s*\\b[^-])'+c+'($|\\b(?=[^-]))', 'g'), '');
				else
					this.className += ( this.className.length > 0 ? " " : "" ) + c;
			});
		},
		remove: function() {
			this.each(function(){this.parentNode.removeChild( this );});
			this.cur = [];
			return this;
		},

		wrap: function() {
			var a = $.clean(arguments);
			return this.each(function(){
				var b = a[0].cloneNode(true);
				this.parentNode.insertBefore( b, this );
				while ( b.firstChild )
					b = b.firstChild;
				b.appendChild( this );
			});
		},

		append: function() {
			var clone = this.size() > 1;
			var a = $.clean(arguments);
			return this.domManip(function(){
				for ( var i = 0; i < a.length; i++ )
				  this.appendChild( clone ? a[i].cloneNode(true) : a[i] );
			});
		},

		appendTo: function() {
			var a = arguments;
			return this.each(function(){
				for ( var i = 0; i < a.length; i++ )
					$(a[i]).append( this );
			});
		},

		prepend: function() {
			var clone = this.size() > 1;
			var a = $.clean(arguments);
			return this.domManip(function(){
				for ( var i = a.length - 1; i >= 0; i-- )
					this.insertBefore( clone ? a[i].cloneNode(true) : a[i], this.firstChild );
			});
		},

		before: function() {
			var clone = this.size() > 1;
			var a = $.clean(arguments);
			return this.each(function(){
				for ( var i = 0; i < a.length; i++ )
					this.parentNode.insertBefore( clone ? a[i].cloneNode(true) : a[i], this );
			});
		},

		after: function() {
			var clone = this.size() > 1;
			var a = $.clean(arguments);
			return this.each(function(){
				for ( var i = a.length - 1; i >= 0; i-- )
					this.parentNode.insertBefore( clone ? a[i].cloneNode(true) : a[i], this.nextSibling );
			});
		},

		empty: function() {
			return this.each(function(){
				while ( this.firstChild )
					this.removeChild( this.firstChild );
			});
		},

		bind: function(t,f) {
			return this.each(function(){$.event.add(this,t,f);});
		},
		unbind: function(t,f) {
			return this.each(function(){$.event.remove(this,t,f);});
		},
		trigger: function(t) {
			return this.each(function(){$.event.trigger(this,t);});
		},

		find: function(t) {
			var old = [], ret = [];
			this.each(function(){
				old[old.length] = this;
				ret = $.merge( ret, $.Select(t,this) );
			});
			this.old = old;
			this.cur = ret;
			return this;
		},
		end: function() {
			this.cur = this.old;
			return this;
		},

		parent: function(a) {
			this.cur = $.map(this.cur,function(d){
				return d.parentNode;
			});
			if ( a ) this.cur = $.filter(a,this.cur).r;
			return this;
		},

		parents: function(a) {
			this.cur = $.map(this.cur,$.parents);
			if ( a ) this.cur = $.filter(a,this.cur).r;
			return this;
		},

		siblings: function(a) {
			// Incorrect, need to exclude current element
			this.cur = $.map(this.cur,$.sibling);
			if ( a ) this.cur = $.filter(a,this.cur).r;
			return this;
		},

		filter: function(t) {
			this.cur = $.filter(t,this.cur).r;
			return this;
		},
		not: function(t) {
			this.cur = t.constructor == String ?
				$.filter(t,this.cur,false).r :
				$.grep(this.cur,function(a){return a != t;});
			return this;
		},
		add: function(t) {
			this.cur = $.merge( this.cur, t.constructor == String ?
				$.Select(t) : t.constructor == Array ? t : [t] );
			return this;
		},
		is: function(t) {
			return $.filter(t,this.cur).r.length > 0;
		},
		isNot: function(t) {
			return !this.s(t);
		}
	};

	// TODO: Remove need to return this
	for ( var i in $.fn ) {
		if ( self[i] !== null )
			self["_"+i] = self[i];
		self[i] = $.fn[i];
	}

	if ( typeof Prototype != "undefined" && $a.constructor != String ) {
		if ( $c ) $a = self.get();
		for ( var k in self ) {(function(j){
			try {
				if ( !$a[j] )
					$a[j] = function() {
						return $.apply(self,self[j],arguments);
					};
			} catch(e) {}
		})(k);}
		return $a;
	}

	return self;
}

(function(){
	var b = navigator.userAgent.toLowerCase();

	// Figure out what browser is being used
	$.browser =
		( /webkit/.test(b) && "safari" ) ||
		( /opera/.test(b) && "opera" ) ||
		( /msie/.test(b) && "msie" ) ||
		( !/compatible/.test(b) && "mozilla" ) ||
		"other";

	// Check to see if the W3C box model is being used
	$.boxModel = ( $.browser != "msie" ||
		document.compatMode == "CSS1Compat" );
})();

$.apply = function(o,f,a) {
	a = a || [];
	if ( f.apply )
		return f.apply( o, a );
	else {
		var p = [];
		for (var i = 0; i < a.length; i++)
			p[i] = 'a['+i+']';
		o.$$exec = this;
		var r = eval('o.$$exec(' + p.join(',') + ')');
		o.$$exec = null;
		return r;
	}
};

$.getCSS = function(e,p) {
	// Adapted from Prototype 1.4.0
	if ( p == 'height' || p == 'width' ) {

		// Handle extra width/height provided by the W3C box model
		var ph = (!$.boxModel ? 0 :
			parseInt($.css(e,"paddingTop")) + parseInt($.css(e,"paddingBottom")) +
			parseInt($.css(e,"borderTopWidth")) + parseInt($.css(e,"borderBottomWidth"))) || 0;

		var pw = (!$.boxModel ? 0 :
			parseInt($.css(e,"paddingLeft")) + parseInt($.css(e,"paddingRight")) +
			parseInt($.css(e,"borderLeftWidth")) + parseInt($.css(e,"borderRightWidth"))) || 0;

		var oHeight, oWidth;

		if ($.css(e,"display") != 'none') {
			oHeight = e.offsetHeight || parseInt(e.style.height) || 0;
			oWidth = e.offsetWidth || parseInt(e.style.width) || 0;
		} else {
			var els = e.style;
			var ov = els.visibility;
			var op = els.position;
			var od = els.display;
			els.visibility = 'hidden';
			els.position = 'absolute';
			els.display = '';
			oHeight = e.clientHeight || parseInt(e.style.height);
			oWidth = e.clientWidth || parseInt(e.style.width);
			els.display = od;
			els.position = op;
			els.visibility = ov;
		}

		return p == 'height' ?
			(oHeight - ph < 0 ? 0 : oHeight - ph) :
			(oWidth - pw < 0 ? 0 : oWidth - pw);
	}

	if (e.style[p])
		return e.style[p];
 	else if (e.currentStyle)
		return e.currentStyle[p];
	else if (document.defaultView && document.defaultView.getComputedStyle) {
		p = p.replace(/([A-Z])/g,"-$1").toLowerCase();
		var s = document.defaultView.getComputedStyle(e,"");
		var r = s ? s.getPropertyValue(p) : null;
		return r;
 	} else
		return null;
};
$.css = $.getCSS;

$.clean = function(a) {
	var r = [];
	for ( var i = 0; i < a.length; i++ ) {
		if ( a[i].constructor == String ) {

			if ( !a[i].indexOf("<tr") ) {
				var tr = true;
				a[i] = "<table>" + a[i] + "</table>";
			} else if ( !a[i].indexOf("<td") || !a[i].indexOf("<th") ) {
				var td = true;
				a[i] = "<table><tbody><tr>" + a[i] + "</tr></tbody></table>";
			}

			var div = document.createElement("div");
			div.innerHTML = a[i];

			if ( tr || td ) {
				div = div.firstChild.firstChild;
				if ( td ) {
					div = div.firstChild;
				}
			}

			for ( var j = 0; j < div.childNodes.length; j++ ) {
				r[r.length] = div.childNodes[j];
			}
		} else if ( a[i].length && !a[i].nodeType ) {
			for ( var k = 0; k < a[i].length; k++ ) {
				r[r.length] = a[i][k];
			}
		} else if ( a[i] !== null ) {
			r[r.length] =
				a[i].nodeType ? a[i] : document.createTextNode(a[i].toString());
		}
	}
	return r;
};

$.fn = {};

/**
 * A wrapper function for each() to be used by append and prepend.
 * Handles cases where you're trying to modify the inner contents of
 * a table, when you actually need to work with the tbody.
 */
$.fn.domManip = function(fn){
	return this.each(function(){
		var obj = this;

		if ( this.nodeName == 'TABLE' ) {
			if ( !this.firstChild ) {
				this.appendChild( document.createElement("tbody") );
			}
			obj = this.firstChild;
		}

		$.apply( obj, fn );
	});
};

$.g = {
	'': "m[2] == '*' || a.nodeName.toUpperCase() == m[2].toUpperCase()",
	'#': "a.getAttribute('id') && a.getAttribute('id').nodeValue == m[2]",
	':': {
		lt: "i < m[3]-0",
		gt: "i > m[3]-0",
		nth: "m[3] - 0 == i",
		eq: "m[3] - 0 == i",
		first: "i == 0",
		last: "i == r.length - 1",
		even: "i % 2 == 0",
		odd: "i % 2 == 1",
		"first-child": "$.sibling(a,0).cur",
		"nth-child": "(m[3] == 'even'?$.sibling(a,m[3]).n % 2 == 0 :(m[3] == 'odd'?$.sibling(a,m[3]).n % 2 == 1:$.sibling(a,m[3]).cur))",
		"last-child": "$.sibling(a,0,true).cur",
		"nth-last-child": "$.sibling(a,m[3],true).cur",
		"first-of-type": "$.ofType(a,0)",
		"nth-of-type": "$.ofType(a,m[3])",
		"last-of-type": "$.ofType(a,0,true)",
		"nth-last-of-type": "$.ofType(a,m[3],true)",
		"only-of-type": "$.ofType(a) == 1",
		"only-child": "$.sibling(a).length == 1",
		parent: "a.childNodes.length > 0",
		empty: "a.childNodes.length == 0",
		root: "a == ( a.ownerDocument ? a.ownerDocument : document ).documentElement",
		contains: "(a.innerText || a.innerHTML).indexOf(m[3]) != -1",
		visible: "(!a.type || a.type != 'hidden') && ($.getCSS(a,'display') != 'none' && $.getCSS(a,'visibility') != 'hidden')",
		hidden: "(a.type && a.type == 'hidden') || $.getCSS(a,'display') == 'none' || $.getCSS(a,'visibility') == 'hidden'",
		enabled: "a.disabled == false",
		disabled: "a.disabled",
		checked: "a.checked"
	},
	".": "$.hasWord(a,m[2])",
	"@": {
		"=": "$.attr(a,m[3]) == m[4]",
		"!=": "$.attr(a,m[3]) != m[4]",
		"~=": "$.hasWord($.attr(a,m[3]),m[4])",
		"|=": "$.attr(a,m[3]).indexOf(m[4]) == 0",
		"^=": "$.attr(a,m[3]).indexOf(m[4]) == 0",
		"$=": "$.attr(a,m[3]).substr( $.attr(a,m[3]).length - m[4].length, m[4].length ) == m[4]",
		"*=": "$.attr(a,m[3]).indexOf(m[4]) >= 0",
		"": "m[3] == '*' ? a.attributes.length > 0 : $.attr(a,m[3])"
	},
	"[": "$.Select(m[2],a).length > 0"
};

$.Select = function( t, context ) {
	context = context || $.context || document;
	if ( t.constructor != String ) {
		return [t];
	}

	if ( t.indexOf("//") === 0 ) {
		context = context.documentElement;
		t = t.substr(2,t.length);
	} else if ( t.indexOf("/") === 0 ) {
		context = context.documentElement;
		t = t.substr(1,t.length);
		// FIX Assume the root element is right :(
		if ( t.indexOf('/') ) {
			t = t.substr(t.indexOf('/'),t.length);
		}
	}

	var ret = [context];
	var done = [];
	var last = null;

	while ( t.length > 0 && last != t ) {
    var r = [];
		last = t;

    t = $.cleanSpaces(t);

    var re = new RegExp( "^//", "i" );
    t = t.replace( re, "" );

		if ( t.indexOf('..') === 0 || t.indexOf('/..') === 0 ) {
			if ( t.indexOf('/') === 0 ) {
				t = t.substr(1,t.length);
			}
			r = $.map( ret, function(a){ return a.parentNode; } );
			t = t.substr(2,t.length);
			t = $.cleanSpaces(t);
		} else if ( t.indexOf('>') === 0 || t.indexOf('/') === 0 ) {
			r = $.map( ret, function(a){ return ( a.childNodes.length > 0 ? $.sibling( a.firstChild ) : null ); } );
			t = t.substr(1,t.length);
			t = $.cleanSpaces(t);
		} else if ( t.indexOf('+') === 0 ) {
			r = $.map( ret, function(a){ return $.sibling(a).next; } );
			t = t.substr(1,t.length);
			t = $.cleanSpaces(t);
		} else if ( t.indexOf('~') === 0 ) {
			r = $.map( ret, function(a){
				var r = [];
				var s = $.sibling(a);
				if ( s.n > 0 ) {
					for ( var i = s.n; i < s.length; i++ ) {
						r[r.length] = s[i];
					}
				}
				return r;
			});
			t = t.substr(1,t.length);
			t = $.cleanSpaces(t);
		} else if ( t.indexOf(',') === 0 || t.indexOf('|') === 0 ) {
			if ( ret[0] == context ) { ret.shift(); }
			done = $.merge( done, ret );
			r = ret = [context];
			t = " " + t.substr(1,t.length);
		} else {
			var re2 = new RegExp( "^([#.]?)([a-z0-9\\*_-]*)", "i" );
			var m = re2.exec(t);

			if ( m[1] == "#" ) { // Ummm, should make this work in all XML docs
				var oid = document.getElementById(m[2]);
				r = ret = oid ? [oid] : [];
				t = t.replace( re2, "" );
			} else {
				if ( m[2] === "" || m[1] == "." ) { m[2] = "*"; }

				for ( var i = 0; i < ret.length; i++ ) {
					var o = ret[i];
					if ( o ) {
						switch( m[2] ) {
							case '*':
								r = $.merge( $.getAll(o), r );
							break;
							case 'text': case 'radio': case 'checkbox': case 'hidden':
							case 'button': case 'submit': case 'image': case 'password':
							case 'reset': case 'file':
								r = $.merge( $.grep( $.tag(o,"input"),
									function(a){ return a.type == m[2]; }), r );
							break;
							case 'input':
								r = $.merge( $.tag(o,"input"), r );
								r = $.merge( $.tag(o,"select"), r );
								r = $.merge( $.tag(o,"textarea"), r );
							break;
							default:
								r = $.merge( r, $.tag(o,m[2]) );
							break;
						}
					}
				}
			}
		}

		if ( t ) {
			var val = $.filter(t,r);
			ret = r = val.r;
			t = $.cleanSpaces(val.t);
		}
	}

	if ( ret && ret[0] == context ) { ret.shift(); }
	done = $.merge( done, ret );

	return done;
};

$.tag = function(a,b){
	return a && typeof a.getElementsByTagName != 'undefined' ?
		a.getElementsByTagName( b ) : [];
};

$.attr = function(o,a,v){
	if ( a && a.constructor == String ) {
		var fix = {
			'for': 'htmlFor',
			'text': 'cssText',
			'class': 'className',
			'float': 'cssFloat'
		};
		a = (fix[a] && fix[a].replace && fix[a]) || a;
		var r = new RegExp("-([a-z])","ig");
		a = a.replace(r,function(z,b){return b.toUpperCase();});
		if ( typeof v != 'undefined' ) {
			o[a] = v;
			if ( o.setAttribute && a != 'disabled' ) {
				o.setAttribute(a,v);
			}
		}
		return o[a] || o.getAttribute(a) || '';
	} else {
		return '';
	}
};

$.filter = function(t,r,not) {
	var g = $.grep;
	if ( not === false ) {
		g = function(a,f) {return $.grep(a,f,true);};
	}

	while ( t.length > 0 && t.match(/^[:\\.#\\[a-zA-Z\\*]/) ) {
		var re = new RegExp( "^\\[ *@([a-z0-9\\*\\(\\)_-]+) *([~!\\|\\*$^=]*) *'?\"?([^'\"]*)'?\"? *\\]", "i" );
		var m = re.exec(t);

		if ( m !== null ) {
			m = ['', '@', m[2], m[1], m[3]];
		} else {
			re = new RegExp( "^(\\[) *([^\\]]*) *\\]", "i" );
			m = re.exec(t);

			if ( m === null ) {
				re = new RegExp( "^(:)([a-z0-9\\*_-]*)\\( *[\"']?([^ \\)'\"]*)['\"]? *\\)", "i" );
				m = re.exec(t);

				if ( m === null ) {
					re = new RegExp( "^([:\\.#]*)([a-z0-9\\*_-]*)", "i" );
					m = re.exec(t);
				}
			}
		}
		t = t.replace( re, "" );

		if ( m[1] == ":" && m[2] == "not" ) {
			r = $.filter(m[3],r,false).r;
		} else {
			var f = null;

			if ( $.g[m[1]].constructor == String ) {
				f = $.g[m[1]];
			} else if ( $.g[m[1]][m[2]] ) {
				f = $.g[m[1]][m[2]];
			}

			if ( f !== null ) {
				eval('f = function(a,i){return ' + f + '}');
				r = g( r, f );
			}
		}
	}

	return { r: r, t: t };
};

$.parents = function(a){
	var b = [];
	var c = a.parentNode;
	while ( c !== null && c != document ) {
		b[b.length] = c;
		c = c.parentNode;
	}
	return b;
};

$.cleanSpaces = function(t){
	return t.replace(/^\s+|\s+$/g, '');
};

$.ofType = function(a,n,e) {
	var t = $.grep($.sibling(a),function(b){return b.nodeName == a.nodeName;});
	if ( e ) { n = t.length - n - 1; }
	return typeof n != 'undefined' ? t[n] == a : t.length;
};

$.sibling = function(a,n,e) {
	var type = [];
	var tmp = a.parentNode.childNodes;
	for ( var i = 0; i < tmp.length; i++ ) {
		if ( tmp[i].nodeType == 1 ) {
			type[type.length] = tmp[i];
		}
		if ( tmp[i] == a ) {
			type.n = type.length - 1;
		}
	}
	if ( e ) { n = type.length - n - 1; }
	type.cur = ( type[n] == a );
	type.prev = ( type.n > 0 ? type[type.n - 1] : null );
	type.next = ( type.n < type.length - 1 ? type[type.n + 1] : null );
	return type;
};

$.hasWord = function(e,a) {
	if ( typeof e == 'undefined' ) { return false; }
	if ( e.className !== null ) { e = e.className; }
	return new RegExp("(^|\\s)" + a + "(\\s|$)").test(e);
};

$.getAll = function(o,r) {
	r = r || [];
	var s = o.childNodes;
	for ( var i = 0; i < s.length; i++ ) {
		if ( s[i].nodeType == 1 ) {
			r[r.length] = s[i];
			$.getAll( s[i], r );
		}
	}
	return r;
};

$.merge = function(a,b) {
	var d = [];
	for ( var k = 0; k < b.length; k++ ) { d[k] = b[k]; }

	for ( var i = 0; i < a.length; i++ ) {
		var c = true;
		for ( var j = 0; j < b.length; j++ ) {
			if ( a[i] == b[j] ) {
				c = false;
			}
		}
		if ( c ) {
			d[d.length] = a[i];
		}
	}

	return d;
};

$.grep = function(a,f,s) {
	var r = [];
	if ( typeof a != 'undefined' ) {
		for ( var i = 0; i < a.length; i++ ) {
			if ( (!s && f(a[i],i)) || (s && !f(a[i],i)) ) {
				r[r.length] = a[i];
			}
		}
	}
	return r;
};

$.map = function(a,f) {
	var r = [];
	for ( var i = 0; i < a.length; i++ ) {
		var t = f(a[i],i);
		if ( t !== null ) {
			if ( t.constructor != Array ) { t = [t]; }
			r = $.merge( t, r );
		}
	}
	return r;
};

$.event = {};

$.closure = function( fun, obj ) {
	// Property names - uniquify them?
	var storage = '$$jQuery_closure_storage';
	var closures = '$$jQuery_closure_list';
	var id = '$$jQuery_closure_id';
	
	// Init object storage
	if( ! window[storage] ) {
		window[storage] = { objs:[null], funs:[null] };
	}
	
	// Make sure the function and optional object have ids and are stored in the object store
	obj = obj || {};
	obj[closures] = obj[closures] || [];
	
	var objId = getId( obj, 'objs' );
	var funId = getId( fun, 'funs' );
	
	function getId( thing, kind ) {
		if( ! thing[id] )
			window[storage][kind][ thing[id] = window[storage][kind].length ] = thing;
		return thing[id];
	};
	
	// Clear references to keep them out of the closure scope
	obj = fun = null;
	
	// Create the closure, store in cache and return result
	return window[storage].objs[objId][closures][funId] = function () {
		return $.apply( this/*window[storage].objs[objId]*/, window[storage].funs[funId], arguments );
	};
};


// Bind an event to an element
// Original by Dean Edwards
$.event.add = function(element, type, handler) {
	// For whatever reason, IE has trouble passing the window object
	// around, causing it to be cloned in the process
	if ( $.browser == "msie" && typeof element.setInterval != "undefined" ) {
		element = window;
	}

	if (!handler.$$guid) { handler.$$guid = $.event.add.guid++; }
	if (!element.events) { element.events = {}; }
	var handlers = element.events[type];
	if (!handlers) {
		handlers = element.events[type] = {};
		if (element["on" + type]) {
			handlers[0] = element["on" + type];
		}
	}
	handlers[handler.$$guid] = $.closure(handler);
	//handlers[handler.$$guid] = handler;
	element["on" + type] = $.event.handle;
};

$.event.add.guid = 1;

// Detach an event or set of events from an element
$.event.remove = function(element, type, handler) {
	if (element.events) {
		if (type && element.events[type]) {
			if ( handler ) {
				delete element.events[type][handler.$$guid];
			} else {
				for ( var i in element.events[type] ) {
					delete element.events[type][i];
				}
			}
		} else {
			for ( var j in element.events ) {
				$.event.remove( element, j );
			}
		}
	}
};

$.event.trigger = function(element,type,data) {
	data = data || [ $.event.fix({ type: type }) ];
	if ( element && element["on" + type] ) {
		$.apply( element, element["on" + type], data );
	}
};

$.event.handle = function(event) {
	if ( !event && !window.event ) { return null; }

	var returnValue = true, handlers = [];
	event = event || $.event.fix(window.event);

	for ( var j in this.events[event.type] ) {
		handlers[handlers.length] = this.events[event.type][j];
	}

	for ( var i = 0; i < handlers.length; i++ ) {
		if ( handlers[i].constructor == Function ) {
			this.$$handleEvent = handlers[i];
			if (this.$$handleEvent(event) === false) {
				event.preventDefault();
				event.stopPropagation();
				returnValue = false;
			}
		}
	}
	return returnValue;
};

$.event.fix = function(event) {
	event.preventDefault = $.event.fix.preventDefault;
	event.stopPropagation = $.event.fix.stopPropagation;
	return event;
};

$.event.fix.preventDefault = function() {
	this.returnValue = false;
};

$.event.fix.stopPropagation = function() {
	this.cancelBubble = true;
};

// Move to module

$.fn.text = function(e) {
	e = e || this.cur;
	var t = "";
	for ( var j = 0; j < e.length; j++ ) {
		for ( var i = 0; i < e[j].childNodes.length; i++ ) {
		 	t += e[j].childNodes[i].nodeType != 1 ?
				e[j].childNodes[i].nodeValue :
				$.fn.text(e[j].childNodes[i].childNodes);
		}
	}
	return t;
};

/*setTimeout(function(){
	if ( typeof Prototype != "undefined" && $.g == null && $.clean == null )
		throw "Error: You are overwriting jQuery, please include jQuery last.";
}, 1000);*/
$.speed = function(s,o) {
	if ( o && o.constructor == Function ) { o = { onComplete: $.closure(o) }; }
	o = o || {};
	var ss = {"crawl":1200,"xslow":850,"slow":600,"medium":400,"fast":200,"xfast":75,"normal":400};
	o.duration = typeof s == "number" ? s : ss[s] || 400;

	o.oldComplete = o.onComplete;
	o.onComplete = function(){
		$.dequeue(this, 'fx');
		if ( o.oldComplete && o.oldComplete.constructor == Function ) {
			$.apply( this, o.oldComplete );
		}
	};

	return o;
};

$.queue = {};

$.dequeue = function(elem,type){
	type = type || 'fx';

	if ( elem.$$queue && elem.$$queue[type] ) {
		// Remove self
		elem.$$queue[type].shift();

		// Get next function
		var f = elem.$$queue[type][0];
	
		if ( f ) {
			$.apply( elem, f );
		}
	}
};

$.fn.queue = function(type,fn){
	if ( !fn ) {
		fn = type;
		type = 'fx';
	}

	return this.each(function(){
		if ( !this.$$queue ) {
			this.$$queue = {};
		}

		if ( !this.$$queue[type] ) {
			this.$$queue[type] = [];
		}

		this.$$queue[type].push( fn );
	
		if ( this.$$queue[type].length == 1 ) {
			$.apply(this,fn);
		}
	});
};

$.fn._hide = $.fn.hide;

$.fn.hide = function(a,o) {
	o = $.speed(a,o);
	return a ? this.queue(function(){
		new $.fx.FadeSize(this,o).hide();
	}) : this._hide();
};

$.fn._show = $.fn.show;

$.fn.show = function(a,o) {
	o = $.speed(a,o);
	return a ? this.queue(function(){
		new $.fx.FadeSize(this,o).show();
	}) : this._show();
};

$.fn.slideDown = function(a,o) {
	o = $.speed(a,o);
	return this.queue(function(){
		new $.fx.Resize(this,o).show("height");
	});
};

$.fn.slideUp = function(a,o) {
	o = $.speed(a,o);
	return this.queue(function(){
		new $.fx.Resize(this,o).hide("height");
	});
};

$.fn.fadeOut = function(a,o) {
	o = $.speed(a,o);
	return a ? this.queue(function(){
		new $.fx.Opacity(this,o,1).hide();
	}) : this._hide();
};

$.fn.fadeIn = function(a,o) {
	o = $.speed(a,o);
	return a ? this.queue(function(){
		new $.fx.Opacity(this,o,1).show();
	}) : this._show();
};

$.fn.fadeTo = function(a,ev,o) {
	o = $.speed(a,o);
	return a ? this.queue(function(){
		ef = new $.fx.Opacity(this,o);
		ef.custom(ef.cur(),parseFloat(ev));
		ef.show();
	}) : this._show();
};

$.fn.center = function(f) {
	return this.each(function(){
		if ( !f && this.nodeName == 'IMG' &&
				 !this.offsetWidth && !this.offsetHeight ) {
			var self = this;
			setTimeout(function(){
				$(self).center(true);
			}, 13);
		} else {
			var s = this.style;
			var p = this.parentNode;
			if ( $.css(p,"position") == 'static' ) {
				p.style.position = 'relative';
			}
			s.position = 'absolute';
			s.left = (($.css(p,"width") - $.css(this,"width"))/2) + "px";
			s.top = (($.css(p,"height") - $.css(this,"height"))/2) + "px";
		}
  });
};

$.setAuto = function(e,p) {
	var a = e.style[p];
	var o = $.css(e,p);
	e.style[p] = 'auto';
	var n = $.css(e,p);
	if ( o != n ) {
		e.style[p] = a;
	}
};

/*
 * I originally wrote fx() as a clone of moo.fx and in the process
 * of making it small in size the code became illegible to sane
 * people. You've been warned.
 */

$.fx = function(el,op,ty){

	var z = this;

	// The users options
	z.o = {
		duration: (op && op.duration) || 400,
		onComplete: (op && op.onComplete) || op
	};

	// The element
	z.el = el;

	// The styles
	var y = z.el.style;

	// Simple function for setting a style value
	z.a = function(){
		z.el.style[ty] = z.now+'px';
	};

	// Figure out the maximum number to run to
	z.max = function(){return z.el["$$orig"+ty]||z.cur();};

	// Get the current size
	z.cur = function(){return $.css(z.el,ty);};

	// Start an animation from one number to another
	z.custom = function(from,to){
		z.startTime = (new Date()).getTime();
		z.now = from;
		z.a();

		z.timer = setInterval(function(){
			z.step(from, to);
		}, 13);
	};

	// Simple 'show' function
	z.show = function(){
		y.display = "block";
		z.o.auto = true;
		z.custom(0,z.max());
	};

	// Simple 'hide' function
	z.hide = function(){
		// Remember where we started, so that we can go back to it later
		z.el["$$orig"+ty] = this.cur();

		// Begin the animation
		z.custom(z.cur(),0);
	};

	// Toggle between showing and hiding an element
	z.toggle = function(){
		if ( z.cur() > 0 ) {
			z.hide();
		} else {
			z.show();
		}
	};
	

	// IE has trouble with opacity if it doesn't have layout
	if ( $.browser == "msie" && !z.el.currentStyle.hasLayout ) {
		y.zoom = 1;
	}
	
	// Remember  the overflow of the element
	z.oldOverflow = y.overflow;

	// Make sure that nothing sneaks out
	y.overflow = "hidden";

	// Each step of an animation
	z.step = function(firstNum, lastNum){
		var t = (new Date()).getTime();

		if (t > z.o.duration + z.startTime) {
			// Stop the timer
			clearInterval(z.timer);
			z.timer = null;

			z.now = lastNum;
			z.a();

			// Reset the overflow
			y.overflow = z.oldOverflow;

			// If the element was shown, and not using a custom number,
			// set its height and/or width to auto
			if ( (ty == "height" || ty == "width") && z.o.auto ) {
				$.setAuto( z.el, ty );
			}

			// If a callback was provided, execute it
			if( z.o.onComplete.constructor == Function ) {

				// Yes, this is a weird place for this, but it needs to be executed
				// only once per cluster of effects.
				// If the element is, effectively, hidden - hide it
				if ( y.height == "0px" || y.width == "0px" ) {
					y.display = "none";
				}

				$.apply( z.el, z.o.onComplete );
			}
		} else {
			// Figure out where in the animation we are and set the number
			var p = (t - this.startTime) / z.o.duration;
			z.now = ((-Math.cos(p*Math.PI)/2) + 0.5) * (lastNum-firstNum) + firstNum;

			// Perform the next step of the animation
			z.a();
		}
	};

};

$.fx.fn = ["show","hide","toggle"];
$.fx.ty = ["Height","Width","Left","Top"];

(function(){
	for(var $i in $.fx.ty){(function(){
		var c = $.fx.ty[$i];
		$.fx[c] = function(a,b){
			return new $.fx(a,b,c.toLowerCase());
		};
	})();}
})();

$.fx.Opacity = function(a,b,sv){
	var o = new $.fx(a,b,"opacity");
	o.cur = function(){return parseFloat(o.el.style.opacity);};
	o.a = function() {
		var e = o.el.style;
		if (o.now == 1) { o.now = 0.9999; }
		if (window.ActiveXObject) {
			e.filter = "alpha(opacity=" + o.now*100 + ")";
		}
		e.opacity = o.now;
	};
	o.io = o.now = (sv || o.cur());
	o.a();
	return o;
};

$.fx.Resize = function(e,o){
	var z = this;
	var h = new $.fx.Height(e,o);
	if(o) { o.onComplete = null; }
	var w = new $.fx.Width(e,o);
	function c(a,b,d){return (!a||a==d||b==d);}
	for(var i in $.fx.fn){(function(){
		var j = $.fx.fn[i];
		z[j] = function(a,b){
			if(c(a,b,"height")) { h[j](); }
			if(c(a,b,"width")) { w[j](); }
		};
	})();}
};

$.fx.FadeSize = function(e,o){
	var z = this;
	var r = new $.fx.Resize(e,o);
	if(o) { o.onComplete = null; }
	var p = new $.fx.Opacity(e,o,1);
	for(var i in $.fx.fn){(function(){
		var j = $.fx.fn[i];
		z[j] = function(a,b){p[j]();r[j](a,b);};
	})();}
};
(function(){
	var e = ["blur","focus","contextmenu","load","resize","scroll","unload",
		"click","dblclick","mousedown","mouseup","mouseenter","mouseleave",
		"mousemove","mouseover","mouseout","change","reset","select","submit",
		"keydown","keypress","keyup","abort","error","ready"];

	for ( var i = 0; i < e.length; i++ ) {
		(function(){
			var o = e[i];
			$.fn[o] = function(f){ return this.bind(o, f); };
			$.fn["un"+o] = function(f){ return this.unbind(o, f); };
			$.fn["do"+o] = function(){ return this.trigger(o); };
			$.fn["one"+o] = function(f){ return this.bind(o, function(e){
				if ( this[o+f] !== null ) { return true; }
				this[o+f]++;
				return $.apply(this,f,[e]);
			}); };
		
			// Deprecated
			//$.fn["on"+o] = function(f){ return this.bind(o, f); };
		})();
	}
})();

$.fn.hover = function(f,g) {
	// Check if mouse(over|out) are still within the same parent element
	return this.each(function(){
		var obj = this;
		$.event.add(this, "mouseover", function(e) {
			var p = ( e.fromElement !== null ? e.fromElement : e.relatedTarget );
			while ( p && p != obj ) { p = p.parentNode; }
			if ( p == obj ) { return false; }
			return $.apply(obj,f,[e]);
		});
		$.event.add(this, "mouseout", function(e) {
			var p = ( e.toElement !== null ? e.toElement : e.relatedTarget );
			while ( p && p != obj ) { p = p.parentNode; }
			if ( p == obj ) { return false; }
			return $.apply(obj,g,[e]);
		});
	});
};

$.$$isReady = false;
$.$$ready = [];

// Handle when the DOM is ready
$.ready = function() {
	if ( !$.$$isReady ) {
		$.$$isReady = true;
		if ( $.$$ready ) {
			for ( var i = 0; i < $.$$ready.length; i++ ) {
				$.apply( document, $.$$ready[i] );
			}
			$.$$ready = [];
		}
	}
};

// If Mozilla is used
if ( $.browser == "mozilla" || $.browser == "opera" ) {
	// Use the handy event callback
	document.addEventListener( "DOMContentLoaded", $.ready, null );

// If IE is used, use the excellent hack by Matthias Miller
// http://www.outofhanwell.com/blog/index.php?title=the_window_onload_problem_revisited
} else if ( $.browser == "msie" ) {
	// Only works if you document.write() it
	document.write('<scr' + 'ipt id=__ie_init defer=true ' + 
		'src=javascript:void(0)><\/script>');

	// Use the defer script hack
	var script = document.getElementById('__ie_init');
	script.onreadystatechange = function() {
		if ( this.readyState == 'complete' ) {
			$.ready();
		}
	};

	// Clear from memory
	script = null;

// If Safari  is used
} else if ( $.browser == "safari" ) {
	$.$$timer = setInterval(function(){
	if ( document.readyState == "loaded" || 
			document.readyState == "complete" ) {

			clearInterval( $.$$timer );
			$.$$timer = null;

			$.ready();
		}
	}, 10);
}

// A fallback, that will always work, just in case
$.event.add( window, "load", $.ready );

/**
 * Bind a function to fire when the DOM is ready.
 */
$.fn.ready = function(f) {
	if ( $.$$isReady ) {
		$.apply( document, f );
	} else {
		if ( ! $.$$ready ) {
			$.$$ready = [];
		}

		$.$$ready.push( f );
	}

	return this;
};

$.fn.toggle = function(a,b) {
	return a && b ? this.click(function(e){
		this.$$last = this.$$last == a ? b : a;
		e.preventDefault();
		return $.apply( this, this.$$last, [e] ) || false;
	}) : this._toggle();
};
// AJAX Plugin
// Docs Here:
// http://jquery.com/docs/ajax/

if ( typeof XMLHttpRequest == 'undefined' && typeof window.ActiveXObject == 'function') {
	XMLHttpRequest = function() {
		return new ActiveXObject((navigator.userAgent.toLowerCase().indexOf('msie 5') >= 0) ?
			"Microsoft.XMLHTTP" : "Msxml2.XMLHTTP");
	};
}

// Counter for holding the active query's
$.xmlActive=0;

$.xml = function( type, url, data, ret ) {
	if ( !url ) {
		ret = type.onComplete;
		var onSuccess = type.onSuccess;
		var onError = type.onError;
		data = type.data;
		url = type.url;
		type = type.type;
	}

	var xml = new XMLHttpRequest();

	if ( xml ) {
		// Open the socket
		xml.open(type || "GET", url, true);
		if ( data )
			xml.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');

		// Set header so calling script knows that it's an XMLHttpRequest
		xml.setRequestHeader('X-Requested-With', 'XMLHttpRequest');

		/* Borrowed from Prototype:
		 * Force "Connection: close" for Mozilla browsers to work around
		 * a bug where XMLHttpReqeuest sends an incorrect Content-length
		 * header. See Mozilla Bugzilla #246651.
		 */
		if ( xml.overrideMimeType )
			xml.setRequestHeader('Connection', 'close');

		xml.onreadystatechange = function() {
			// Socket is openend
			if ( xml.readyState == 1 ) {
				// Increase counter
				$.xmlActive++;

				// Show loader if needed
				if ( ($.xmlActive >= 1) && ($.xmlCreate) )
					$.xmlCreate();
			}

			// Socket is closed and data is available
			if ( xml.readyState == 4 ) {
				// Decrease counter
				$.xmlActive--;

				// Hide loader if needed
				if ( ($.xmlActive <= 0) && ($.xmlDestroy) ) {
					$.xmlDestroy();
					$.xmlActive = 0
				}

				if ( ( xml.status && ( xml.status >= 200 && xml.status < 300 ) || xml.status == 304 ) ||
					!xml.status && location.protocol == 'file:' ) {
					if ( onSuccess )
						onSuccess( xml );
				} else if ( onError ) {
					onError( xml );
				}

				// Process result
				if ( ret )
					ret(xml);
				xml = null
			}
		};

		xml.send(data)
	}
};

$.httpData = function(r,type) {
	return r.getResponseHeader("content-type").indexOf("xml") > 0 || type == "xml" ?
		r.responseXML : r.responseText;
};

$.get = function( url, ret, type ) {
	$.xml( "GET", url, null, function(r) {
		if ( ret ) { ret( $.httpData(r,type) ); }
	});
};

$.getXML = function( url, ret ) {
	$.get( url, ret, "xml" );
};

$.post = function( url, data, ret, type ) {
	$.xml( "POST", url, $.param(data), function(r) {
		if ( ret ) { ret( $.httpData(r,type) ); }
	});
};

$.postXML = function( url, data, ret ) {
	$.post( url, data, ret, "xml" );
};

$.param = function(a) {
	var s = [];
	if (a && typeof a == 'object' && a.constructor == Array) {
		for ( var i=0; i < a.length; i++ ) {
			s[s.length] = a[i].name + "=" + encodeURIComponent( a[i].value );
		}
	} else {
		for ( var j in a ) {
			s[s.length] = j + "=" + encodeURIComponent( a[j] );
		}
	}
	return s.join("&");
};

$.fn.load = function(a,o,f) {
	// Arrrrghhhhhhhh!!
	// I overwrote the event plugin's .load
	// this won't happen again, I hope -John
	if ( a && a.constructor == Function ) {
		return this.bind("load", a);
	}

	var t = "GET";
	if ( o && o.constructor == Function ) {
		f = o;
		o = null;
	}
	if (typeof o !== 'undefined') {
		o = $.param(o);
		t = "POST";
	}
	var self = this;
	$.xml(t,a,o,function(res){
		// Assign it and execute all scripts
		self.html(res.responseText).find("script").each(function(){
			try { eval( this.text || this.textContent || this.innerHTML || ""); } catch(e){}
		});

		// Callback function
		if (f && f.constructor == Function)
			f(res.responseText);
	});
	return this;
};

/**
 * Initial frontend function to submit form variables. This function
 * is for registering coordinates, in the case of an image being used
 * as the submit element, and sets up an event to listen and wait for
 * a form submit click. It then calls any following chained functions
 * to actually gather the variables and submit them.
 *
 * Usage examples, when used with getForm().putForm():
 *
 * 1. Just eval the results returned from the backend.
 *    $('#form-id').form();
 *
 * 2. Render backend results directly to target ID (expects (x)HTML).
 *    $('#form-id').form('#target-id');
 *
 * 3. Submit to backend URL (form action) then call this function.
 *    $('#form-id').form(post_callback);
 *
 * 4. Load target ID with backend results then call a function.
 *    $('#form-id').form('#target-id', null, post_callback);
 *
 * 5. Call a browser function (for validation) and then (optionally)
 *    load server results to target ID.
 *    $('#form-id').form('#target-id', pre_callback);
 *
 * 6. Call validation function first then load server results to
 *    target ID and then also call a browser function.
 *    $('#form-id').form('#target-id', pre_callback, post_callback);
 *
 * @param target   arg for the target id element to render
 * @param pre_cb   callback function before submission
 * @param post_cb  callback after any results are returned
 * @return         "this" object
 * @see            getForm(), putForm()
 * @author         Mark Constable (markc@renta.net)
 * @author         G. vd Hoven, Mike Alsup, Sam Collett
 * @version        20060606
 */
$.fn.form = function(target, pre_cb, post_cb) {
	$('input[@type="submit"],input[@type="image"]', this).click(function(ev){
		this.form.clicked = this;
		if (ev.offsetX != undefined) {
			this.form.clicked_x = ev.offsetX;
			this.form.clicked_y = ev.offsetY;
		} else {
			this.form.clicked_x = ev.pageX - this.offsetLeft;
			this.form.clicked_y = ev.pageY - this.offsetTop;
		}
	});
	this.submit(function(e){
		e.preventDefault();
		$(this).getForm().putForm(target, pre_cb, post_cb);
		return this;
  });
};

/**
 * This function gathers form element variables into an array that
 * is embedded into the current "this" variable as "this.vars". It
 * is normally used in conjunction with form() and putForm() but can
 * be used standalone as long as an image is not used for submission.
 *
 * Standalone usage examples:
 *
 * 1. Gather form vars and return array to LHS variable.
 *    var myform = $('#form-id').getForm();
 *
 * 2. Provide a serialized URL-ready string (after 1. above).
 *    var mystring = $.param(myform.vars);
 *
 * 3. Gather form vars and send to RHS plugin via "this.vars".
 *    $('#form-id').getForm().some_other_plugin();
 *
 * @return         "this" object
 * @see            form(), putForm()
 * @author         Mark Constable (markc@renta.net)
 * @author         G. vd Hoven, Mike Alsup, Sam Collett
 * @version        20060606
 */
$.fn.getForm = function() {
  var a = [];
  var ok = {INPUT:true, TEXTAREA:true, OPTION:true};
  $('*', this).each(function() {
    if (this.disabled || this.type == 'reset' || (this.type == 'checkbox' && !this.checked) || (this.type == 'radio' && !this.checked))
    	return;

    if (this.type == 'submit' || this.type == 'image') {
      if (this.form.clicked != this)
      	return;

      if (this.type == 'image') {
        if (this.form.clicked_x) {
					a.push({name: this.name+'_x', value: this.form.clicked_x});
					a.push({name: this.name+'_y', value: this.form.clicked_y});
					return;
				}
			}
		}

		if (!ok[this.nodeName.toUpperCase()])
			return;

		var par = this.parentNode;
		var p = par.nodeName.toUpperCase();
		if ((p == 'SELECT' || p == 'OPTGROUP') && !this.selected)
			return;

		var n = this.name || par.name;
		if (!n && p == 'OPTGROUP' && (par = par.parentNode))
			n = par.name;

		if (n == undefined)
			return;

		a.push({name: n, value: this.value});
	});

	this.vars = a;

	return this;
}

/**
 * Final form submission plugin usually used in conjunction with
 * form() and getForm(). If a second argument is a valid function
 * then it will be called before the form vars are sent to the
 * backend. If this pre-submit function returns exactly "false"
 * then it will abort further processing otherwise the process
 * will continue according to the first and third arguments.
 *
 * If the first argument is a function, and it exists, then the form
 * values will be submitted and that callback function called. If
 * the first argument is a string value then the "load()" plugin
 * will be called which will populate the innerHTML of the indicated
 * element and a callback will be called if there is third argument.
 * If there are no arguments then the form values are submitted with
 * an additional variable (evaljs=1) which indicates to the backend
 * to to prepare the returned results for evaluation, ie; the result
 * needs to be valid javascript all on a single line.
 *
 * Usage example:
 *
 * $.fn.myvars = function() {
 *   this.vars = [];
 *   for (var i in this) {
 *     if (this[i] instanceof Function || this[i] == null) continue;
 *     this.vars.push({name: i, value: this[i].length});
 *   }
 *   return this;
 * }
 *
 * precb = function(vars) {
 *   return confirm('Submit these values?\n\n'+$.param(vars));
 * }
 *
 * $('*').myvars().putForm('#mytarget',precb,null,'myhandler.php');
 *
 * @param target   arg for the target id element to render
 * @param pre_cb   callback function before submission
 * @param post_cb  callback after any results are returned
 * @param url      form action override
 * @param mth      form method override
 * @return         "this" object
 * @see            form(), getForm(), load(), xml()
 * @author         Mark Constable (markc@renta.net)
 * @author         G. vd Hoven, Mike Alsup, Sam Collett
 * @version        20060606
 */
$.fn.putForm = function(target, pre_cb, post_cb, url, mth) {
	if (pre_cb && pre_cb.constructor == Function)
		if (pre_cb(this.vars) === false)
			return;

	var f = this.get(0);
	var url = url || f.action || '';
	var mth = mth || f.method || 'POST';

	if (target && target.constructor == Function) {
		$.xml(mth, url, $.param(this.vars), target);
	} else if (target && target.constructor == String) {
		$(target).load(url, this.vars, post_cb);
	} else {
		this.vars.push({name: 'evaljs', value: 1});
		$.xml(mth, url, $.param(this.vars), function(r) { eval(r.responseText); });
	}

	return this;
}
// JavaScript Document