/*
 * Decompiled with CFR 0.152.
 */
package com.uisrael.service.impl;

import com.uisrael.entity.Calculadora;
import com.uisrael.repository.CalculadoraRepository;
import com.uisrael.service.CalculadoraService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CalculadoraServiceImpl
implements CalculadoraService {
    @Autowired
    private CalculadoraRepository calculadoraRepository;

    public List<Calculadora> obtenerInversion() {
        return this.calculadoraRepository.findAll();
    }

    public Calculadora obtenerPorId(Integer id) {
        return this.calculadoraRepository.findById((Object)id).orElse(null);
    }

    public Calculadora crearInversion(Calculadora calculadora) {
        return (Calculadora)this.calculadoraRepository.save((Object)calculadora);
    }

    public Long contarClientes() {
        return this.calculadoraRepository.count();
    }

    public double obtenerTasa(int n) {
        return switch (n) {
            case 2 -> 0.05;
            case 4 -> 0.07;
            case 12 -> 0.11;
            default -> 0.0;
        };
    }

    public String categorizarCliente(double capital, int n) {
        if (n == 12 || n == 4 || n == 2) {
            if (capital >= 100.0 && capital <= 500.0) {
                return "Categor\u00eda 3";
            }
            if (capital >= 501.0 && capital <= 1000.0) {
                return "Categor\u00eda 2";
            }
            if (capital > 1000.0) {
                return "Categor\u00eda 1";
            }
        }
        return "Sin categor\u00eda";
    }

    public double calcularMontoFinal(double capitalInicial, double tasa, int numeroPeriodos, int tiempo) {
        return capitalInicial * Math.pow(1.0 + tasa / (double)numeroPeriodos, numeroPeriodos * tiempo);
    }
}

