/*
 * Decompiled with CFR 0.152.
 */
package com.uisrael.controller;

import com.uisrael.entity.Calculadora;
import com.uisrael.repository.CalculadoraRepository;
import com.uisrael.service.CalculadoraService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/calculadora"})
public class CalculadoraController {
    @Autowired
    private CalculadoraService calculadoraService;
    @Autowired
    private CalculadoraRepository repo;

    @GetMapping(value={"/resultados"})
    public String verResultados(Model model) {
        model.addAttribute("simulaciones", (Object)this.repo.findAll());
        return "listar";
    }

    @GetMapping(value={"/nueva"})
    public String mostrarFormularioNuevaInversion(Model model) {
        model.addAttribute("calculadora", (Object)new Calculadora());
        return "formulario";
    }

    @PostMapping(value={"/nueva"})
    public String procesarFormulario(@Valid @ModelAttribute Calculadora calculadora, BindingResult bindingResult, Model model) {
        if (bindingResult.hasErrors()) {
            return "formulario";
        }
        double tasa = this.calculadoraService.obtenerTasa(calculadora.getPeriodo());
        calculadora.setTasa(tasa);
        double monto = this.calculadoraService.calcularMontoFinal(calculadora.getCapital(), tasa, calculadora.getPeriodo(), calculadora.getTiempo());
        calculadora.setMonto(monto);
        calculadora.setInteres(monto - calculadora.getCapital());
        calculadora.setCategoria(this.calculadoraService.categorizarCliente(calculadora.getCapital(), calculadora.getPeriodo()));
        System.out.println("Guardando inversi\u00f3n: " + calculadora.getNombres() + ", monto: " + calculadora.getMonto());
        this.repo.save((Object)calculadora);
        return "redirect:/calculadora/resultados";
    }
}

